/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.Nullable;

public class SkullRenderable
implements RenderableAccessory {
    public static final Codec<SkullRenderable> CODEC = RecordCodecBuilder.create(in -> in.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(s -> s.headStack), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(s -> s.colorHelper), (App)ResolvableProfile.CODEC.optionalFieldOf("profile").forGetter(s -> Optional.ofNullable(s.profile))).apply((Applicative)in, (head, color, profile) -> new SkullRenderable((Item)head, (ColorHelper)color, profile.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkullRenderable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), s -> s.headStack, ColorHelper.STREAM_CODEC, s -> s.colorHelper, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResolvableProfile.STREAM_CODEC), s -> Optional.ofNullable(s.profile), (head, color, profile) -> new SkullRenderable((Item)head, (ColorHelper)color, profile.orElse(null)));
    private static final float RANDOM_SCALE_FACTOR = 1.1875f;
    private final Item headStack;
    private final ColorHelper colorHelper;
    @Nullable
    private final ResolvableProfile profile;

    public SkullRenderable(Item headStack) {
        this(headStack, ColorHelper.EMPTY, null);
    }

    public SkullRenderable(Item headStack, String playerName) {
        this(headStack, ColorHelper.EMPTY, new ResolvableProfile(Optional.of(playerName), Optional.empty(), new PropertyMap()));
    }

    public SkullRenderable(Item headStack, ColorHelper colorHelper, ResolvableProfile profile) {
        BlockItem blockItem;
        this.headStack = headStack;
        this.colorHelper = colorHelper;
        this.profile = profile;
        if (!colorHelper.isEmpty() && headStack instanceof BlockItem && !((blockItem = (BlockItem)headStack).getBlock() instanceof AbstractSkullBlock)) {
            ClaySoldiersCommon.LOGGER.error("SkullRenderer Color only supported for Skulls not blocks");
        }
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClaySoldierEntity claySoldier, float pPartialTick, boolean isFalling) {
        Block block;
        Item item = this.headStack;
        pPoseStack.pushPose();
        if (claySoldier.isBaby()) {
            pPoseStack.translate(0.0f, 0.03125f, 0.0f);
            pPoseStack.scale(0.7f, 0.7f, 0.7f);
            pPoseStack.translate(0.0f, 1.0f, 0.0f);
        }
        renderedFrom.getSoldierModel().getHead().translateAndRotate(pPoseStack);
        if (item instanceof BlockItem && (block = ((BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            WalkAnimationState walkanimationstate;
            AbstractSkullBlock abstractSkullBlock = (AbstractSkullBlock)block;
            pPoseStack.scale(1.1875f, -1.1875f, -1.1875f);
            pPoseStack.translate(-0.5, 0.0, -0.5);
            SkullBlock.Type skyllType = abstractSkullBlock.getType();
            SkullModelBase skullmodelbase = renderedFrom.getSkullBase(skyllType);
            if (skullmodelbase == null) {
                return;
            }
            RenderType rendertype = SkullBlockRenderer.getRenderType((SkullBlock.Type)skyllType, (ResolvableProfile)this.profile);
            Entity entity = claySoldier.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                walkanimationstate = livingentity.walkAnimation;
            } else {
                walkanimationstate = claySoldier.walkAnimation;
            }
            float f3 = walkanimationstate.position(pPartialTick);
            SkullRenderable.renderSkull(f3, pPoseStack, pBuffer, pPackedLight, skullmodelbase, rendertype, this.colorHelper, (LivingEntity)claySoldier, pPartialTick);
        } else {
            CustomHeadLayer.translateToHead((PoseStack)pPoseStack, (boolean)false);
            renderedFrom.getItemInHandRenderer().renderItem((LivingEntity)claySoldier, this.headStack.getDefaultInstance(), ItemDisplayContext.HEAD, false, pPoseStack, pBuffer, pPackedLight);
        }
        pPoseStack.popPose();
    }

    private static void renderSkull(float pMouthAnimation, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, SkullModelBase pModel, RenderType pRenderType, ColorHelper colorHelper, LivingEntity soldier, float partialTick) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.0f, 0.5f);
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(pRenderType);
        pModel.setupAnim(pMouthAnimation, 180.0f, 0.0f);
        pModel.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, colorHelper.getColor(soldier, partialTick));
        pPoseStack.popPose();
    }
}

