/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class StringRenderLayer
implements RenderableAccessory {
    public static final Codec<StringRenderLayer> CODEC = ResourceLocation.CODEC.xmap(StringRenderLayer::new, s -> s.textureLocation);
    public static final StreamCodec<ByteBuf, StringRenderLayer> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(StringRenderLayer::new, s -> s.textureLocation);
    private final ResourceLocation textureLocation;
    private RenderType renderType = null;

    public StringRenderLayer() {
        this(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_soldier/wrapped.png"));
    }

    public StringRenderLayer(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClaySoldierEntity claySoldier, float pPartialTick, boolean isFalling) {
        if (this.renderType == null) {
            this.renderType = RenderType.entityTranslucent((ResourceLocation)this.textureLocation);
        }
        VertexConsumer stringBuffer = pBuffer.getBuffer(this.renderType);
        renderedFrom.getSoldierModel().renderToBuffer(pPoseStack, stringBuffer, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)claySoldier, (float)0.0f));
    }
}

