/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.entity.ClayMobRideableEntity;
import net.bumblebee.claysoldiers.entity.goal.UseAssignedPoiGoal;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModParticles;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.BrickedItemHolder;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.TestItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.bumblebee.claysoldiers.team.TeamHolder;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClayMobEntity
extends PathfinderMob
implements TeamHolder {
    public static final float DEFAULT_SCALE = 0.25f;
    protected static final double DEFAULT_ATTACK_REACH = (double)0.7f;
    private static final EntityDataAccessor<Boolean> SLIME_ROOT_SYNC = SynchedEntityData.defineId(ClayMobEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(ClayMobEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> HAS_POI_POS = SynchedEntityData.defineId(ClayMobEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> USING_POI = SynchedEntityData.defineId(ClayMobEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String WORK_POI_LANG_KEY = "clay_mob_work.%s.poi.%s";
    public static final String WORK_POI_CLEARED_LANG = "clay_mob_work.%s.poi.%s".formatted("csr", "cleared");
    public static final String WORK_POI_INVALID_LANG = "clay_mob_work.%s.poi.%s".formatted("csr", "invalid");
    protected static final byte SITTING_FLAG = 1;
    private static final byte WAXED_FLAG = 2;
    public static final String SITTING_TAG = "Sitting";
    public static final String WAXED_TAG = "Waxed";
    public static final String POI_POS_TAG = "PoiPos";
    public static final String SPAWNED_FROM_TAG = "SpawnedFrom";
    public static final String DROP_SPAWNED_FROM_TAG = "DropSpawnedFrom";
    protected static final byte TEAM_CHANGE_EVENT = 77;
    protected static final byte SPAWN_HEARTS_EVENT = 78;
    protected static final byte SPAWN_ANGRY_EVENT = 79;
    protected static final byte SPAWN_HAPPY_EVENT = 80;
    protected DamageCalculator inWallDamage = (w, e) -> w ? 0.5f : 1.0f;
    protected DamageCalculator ownerDamage = (w, e) -> 100.0f;
    protected DamageCalculator otherPlayerDamage = (w, e) -> w ? 8.0f : 100.0f;
    protected DamageCalculator explosionDamage = (w, e) -> w ? 0.4f : 0.5f;
    protected DamageCalculator clayDamage = (w, e) -> (float)this.getVisibilityPercent(e);
    protected DamageCalculator defaultDamage = (w, e) -> w ? 75.0f : 100.0f;
    private final DamageSources clayDamageSources;
    private ItemStack spawnedFrom = ItemStack.EMPTY;
    private boolean dropSpawnedFrom = false;
    @Nullable
    private BlockPos poiPos = null;
    @Nullable
    private IBlockCache<AssignablePoiCapability> poiPosCapability;
    private boolean orderedToSit = false;
    @Nullable
    private IClayMobTeamReference cachedTeam = null;
    @Nullable
    public TeamPlayerData teamPlayerData = null;
    @Nullable
    private TeamPlayerData.PlayerData cachedTeamOwner = null;
    private long lastOwnerChange = -1L;

    protected ClayMobEntity(EntityType<? extends ClayMobEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.clayDamageSources = ClaySoldiersCommon.PLATFORM.createClayDamageSources(pLevel.registryAccess());
        this.getPlayerTeamData(pLevel);
        this.setPersistenceRequired();
    }

    private void getPlayerTeamData(Level level) {
        if (this.teamPlayerData != null) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.teamPlayerData = TeamLoyaltyManger.getTeamPlayerData(serverLevel);
        } else {
            this.teamPlayerData = TeamLoyaltyManger.getClientTeamPlayerData();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLIME_ROOT_SYNC, (Object)false);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(HAS_POI_POS, (Object)false);
        builder.define(USING_POI, (Object)false);
    }

    public boolean isSlimeRooted() {
        return (Boolean)this.entityData.get(SLIME_ROOT_SYNC);
    }

    public void setSlimeRooted(boolean slimeRooted) {
        this.entityData.set(SLIME_ROOT_SYNC, (Object)slimeRooted);
    }

    protected void onEffectAdded(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        super.onEffectAdded(pEffectInstance, pEntity);
        if (pEffectInstance.getEffect().is(ModEffects.SLIME_ROOT)) {
            Entity entity = this.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity livingVehicle = (LivingEntity)entity;
                livingVehicle.addEffect(pEffectInstance);
            }
            this.setSlimeRooted(true);
        }
    }

    protected void onEffectRemoved(MobEffectInstance pEffectInstance) {
        super.onEffectRemoved(pEffectInstance);
        if (pEffectInstance.getEffect().is(ModEffects.SLIME_ROOT)) {
            this.setSlimeRooted(false);
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (!this.spawnedFrom.isEmpty()) {
            pCompound.put(SPAWNED_FROM_TAG, this.spawnedFrom.save((HolderLookup.Provider)this.registryAccess()));
            pCompound.putBoolean(DROP_SPAWNED_FROM_TAG, this.dropSpawnedFrom);
        }
        pCompound.putBoolean(SITTING_TAG, this.orderedToSit);
        pCompound.putBoolean(WAXED_TAG, this.isWaxed());
        if (this.getPoiPos() != null) {
            pCompound.put(POI_POS_TAG, NbtUtils.writeBlockPos((BlockPos)this.getPoiPos()));
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains(SPAWNED_FROM_TAG, 10)) {
            this.spawnedFrom = ClayMobEntity.getSpawnedFromFromTag(pCompound, this.registryAccess());
            if (pCompound.contains(DROP_SPAWNED_FROM_TAG)) {
                this.dropSpawnedFrom = pCompound.getBoolean(DROP_SPAWNED_FROM_TAG);
            }
        }
        if (this.hasEffect(ModEffects.SLIME_ROOT)) {
            this.setSlimeRooted(true);
        }
        this.orderedToSit = pCompound.getBoolean(SITTING_TAG);
        this.setInSittingPose(this.orderedToSit);
        if (this.orderedToSit) {
            this.setPose(Pose.SITTING);
        }
        this.setWaxed(pCompound.getBoolean(WAXED_TAG));
        this.setPoiPos(NbtUtils.readBlockPos((CompoundTag)pCompound, (String)POI_POS_TAG).orElse(null));
    }

    public static ItemStack getSpawnedFromFromTag(CompoundTag tag, RegistryAccess registries) {
        return ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(SPAWNED_FROM_TAG));
    }

    public DamageSources damageSources() {
        return this.clayDamageSources;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (amount == Float.MAX_VALUE || source.is(DamageTypes.GENERIC_KILL)) {
            return super.hurt(source, amount);
        }
        if (source.is(DamageTypes.CRAMMING)) {
            return false;
        }
        if (this.sameTeamAs(source.getEntity()) && !this.getClayTeam().isFriendlyFireAllowed()) {
            return false;
        }
        float newDamage = amount;
        boolean waxed = this.isWaxed();
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            newDamage *= this.explosionDamage.calculate(waxed, source.getEntity());
        }
        if (source.is(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE) || source.getEntity() instanceof ClayMobEntity) {
            Entity entity = this.getVehicle();
            if (entity instanceof ClayMobRideableEntity) {
                ClayMobRideableEntity rideableEntity = (ClayMobRideableEntity)entity;
                rideableEntity.hurt(source, newDamage * rideableEntity.shareDamagePercent());
                newDamage *= 1.0f - rideableEntity.shareDamagePercent();
            }
            newDamage *= this.clayDamage.calculate(waxed, source.getEntity());
        } else {
            Player player;
            Entity entity = source.getEntity();
            newDamage = entity instanceof Player ? (newDamage *= this.isOwnedBy(player = (Player)entity) ? this.ownerDamage.calculate(waxed, (Entity)player) : this.otherPlayerDamage.calculate(waxed, (Entity)player)) : (source.is(DamageTypes.IN_WALL) ? (newDamage *= this.inWallDamage.calculate(waxed, source.getEntity())) : (newDamage *= this.defaultDamage.calculate(waxed, source.getEntity())));
        }
        return super.hurt(source, newDamage);
    }

    public float getCustomArmorValue() {
        return 0.0f;
    }

    public void setSpawnedFrom(ItemStack spawnedFrom, boolean allowDropping) {
        this.spawnedFrom = spawnedFrom;
        this.dropSpawnedFrom = allowDropping;
    }

    public boolean dropSpawnedFrom() {
        return this.dropSpawnedFrom;
    }

    public ItemStack getSpawnedFrom() {
        return this.spawnedFrom;
    }

    protected AABB getAttackBoundingBox() {
        AABB aabb;
        double attackReach;
        Entity vehicle = this.getVehicle();
        double d = attackReach = this.isSlimeRooted() ? this.getDefaultAttackReach() * 0.7 : this.getDefaultAttackReach();
        if (vehicle != null) {
            AABB aabb1 = vehicle.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = this.getBoundingBox();
        }
        return aabb.inflate(attackReach, 0.0, attackReach);
    }

    protected abstract double getDefaultAttackReach();

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource pSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(serverLevel, pSource, pRecentlyHit);
        if (!this.dropSpawnedFrom) {
            return;
        }
        ClayMobEntity.dropSpawnedFrom(serverLevel, this.spawnedFrom, arg_0 -> ((ClayMobEntity)this).spawnAtLocation(arg_0), pSource.getEntity() instanceof Player, this.isOnFire());
    }

    public static void dropSpawnedFrom(ServerLevel level, ItemStack spawnedFrom, Consumer<ItemStack> spawnInWorld, boolean alwaysDrop, boolean onFire) {
        float chance;
        float f = chance = alwaysDrop ? 1.0f : (float)level.getLevelData().getGameRules().getInt(ClaySoldiersCommon.CLAY_SOLDIER_DROP_RULE) / 100.0f;
        if (chance >= level.random.nextFloat()) {
            Item item;
            if (onFire && (item = spawnedFrom.getItem()) instanceof BrickedItemHolder) {
                BrickedItemHolder brickedItemHolder = (BrickedItemHolder)item;
                spawnInWorld.accept(brickedItemHolder.getBrickedItem(spawnedFrom));
            } else {
                spawnInWorld.accept(spawnedFrom);
            }
        }
    }

    public boolean isAbleToRide() {
        return false;
    }

    public boolean canMountEntity(LivingEntity livingEntity) {
        return false;
    }

    public boolean canBeKilledByItem() {
        return true;
    }

    public void spawnItemBreakParticles(ItemStack pStack, int pAmount) {
        if (pStack.isEmpty()) {
            return;
        }
        for (int i = 0; i < pAmount; ++i) {
            Vec3 vec3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3 = vec3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec31 = vec31.yRot(-this.getYRot() * ((float)Math.PI / 180));
            vec31 = vec31.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, pStack), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 60: {
                return;
            }
            case 78: {
                this.spawnParticleAround((ParticleOptions)ModParticles.SMALL_HEART_PARTICLE.get());
                return;
            }
            case 79: {
                this.spawnParticleAround((ParticleOptions)ModParticles.SMALL_ANGRY_PARTICLE.get());
                return;
            }
            case 80: {
                this.spawnParticleAround((ParticleOptions)ModParticles.SMALL_HAPPY_PARTICLE.get());
                return;
            }
        }
        super.handleEntityEvent(id);
    }

    public boolean isInvisibleTo(Player pPlayer) {
        return false;
    }

    protected OptionalInt openMenuScreen(Player player) {
        return OptionalInt.empty();
    }

    protected Component getInventoryName() {
        return this.getDisplayName();
    }

    protected InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        if (ModItems.TEST_ITEM.is(pPlayer.getItemInHand(pHand))) {
            if (pHand == InteractionHand.MAIN_HAND) {
                TestItem.log(this, this.getInfoState());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (pPlayer.isShiftKeyDown() && pPlayer.isCreative()) {
            if (!this.level().isClientSide && this.openMenuScreen(pPlayer).isPresent()) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        ItemStack itemInHand = pPlayer.getItemInHand(pHand);
        ClayBrushItem.Mode mode = ClayBrushItem.getMode(itemInHand);
        if (mode != null && this.isOwnedBy(pPlayer)) {
            this.clayBrushEffect(mode, itemInHand, pPlayer);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.isClayFood(itemInHand)) {
            this.heal(this.getMaxHealth());
            itemInHand.consume(1, (LivingEntity)pPlayer);
            if (this.level().isClientSide()) {
                this.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                this.spawnParticleAround((ParticleOptions)ModParticles.SMALL_HEART_PARTICLE.get());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (itemInHand.is(ModTags.Items.CLAY_WAX)) {
            itemInHand.consume(1, (LivingEntity)pPlayer);
            this.setWaxed(true);
            if (this.level().isClientSide()) {
                this.playSound(SoundEvents.HONEYCOMB_WAX_ON, 1.0f, 1.0f);
                this.spawnParticleAround((ParticleOptions)ModParticles.SMALL_WAXED_PARTICLE.get());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    protected boolean isClayFood(ItemStack stack) {
        return stack.is(ModTags.Items.CLAY_FOOD);
    }

    protected boolean clayBrushEffect(ClayBrushItem.Mode mode, ItemStack itemInHand, Player player) {
        if (mode == ClayBrushItem.Mode.COMMAND) {
            if (!this.level().isClientSide()) {
                this.tryToSit(player, !this.isOrderedToSit());
            }
            return true;
        }
        if (mode == ClayBrushItem.Mode.POI) {
            if (!this.level().isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.setPoiPos(ClayBrushItem.getPoiPos(itemInHand));
                serverPlayer.sendSystemMessage(this.getPoiSetDisplayName(), true);
            }
            return true;
        }
        return false;
    }

    public Component getPoiSetDisplayName() {
        if (this.getPoiPos() == null) {
            return Component.translatable((String)WORK_POI_CLEARED_LANG);
        }
        BlockState blockState = this.level().getBlockState(this.getPoiPos());
        if (blockState.isAir()) {
            this.setPoiPos(null);
            return Component.translatable((String)WORK_POI_INVALID_LANG, (Object[])new Object[]{Component.translatable((String)Blocks.AIR.getDescriptionId())});
        }
        return Component.translatable((String)blockState.getBlock().getDescriptionId()).append(" (" + this.getPoiPos().toShortString() + ")");
    }

    protected void tryToSit(@Nullable Player player, boolean sitting) {
        this.setOrderedToSit(sitting);
        this.jumping = false;
        this.navigation.stop();
        this.setTarget(null);
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)livingEntity;
            clayMob.tryToSit(null, sitting);
        }
    }

    protected void spawnParticleAround(ParticleOptions particleOptions) {
        for (int i = 0; i < 2; ++i) {
            double xSpeed = this.random.nextGaussian() * 0.02;
            double ySpeed = this.random.nextGaussian() * 0.02;
            double zSpeed = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOptions, this.getRandomX(0.5), this.getRandomY() + 0.25, this.getRandomZ(0.5), xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    @NotNull
    public ClayMobTeam getClayTeam() {
        ResourceLocation team = this.getClayTeamType();
        if (this.cachedTeam == null || !this.cachedTeam.isValidForKey(team)) {
            this.cachedTeam = ClayMobTeamManger.getReferenceOrDefault(team, this.registryAccess(), () -> {
                ClayMobTeamManger.LOGGER.error("{} has a Team ({}) that does not exist anymore", (Object)this.getClass().getSimpleName(), (Object)team);
                this.setClayTeamType(ClayMobTeamManger.DEFAULT_TYPE);
            });
        }
        return this.cachedTeam == null ? ClayMobTeamManger.ERROR : this.cachedTeam.value();
    }

    @Override
    @Nullable
    public UUID getClayTeamOwnerUUID() {
        return this.getCachedTeamOwner().map(TeamPlayerData.PlayerData::getUUID).orElse(null);
    }

    @Override
    @Nullable
    public Player getClayTeamOwner() {
        if (this.getClayTeamOwnerUUID() == null) {
            return null;
        }
        return this.level().getPlayerByUUID(this.getClayTeamOwnerUUID());
    }

    public Component getOwnerDisplayName() {
        return this.getCachedTeamOwner().map(TeamPlayerData.PlayerData::getLastDisplayName).orElse(null);
    }

    private Optional<TeamPlayerData.PlayerData> getCachedTeamOwner() {
        if (this.teamPlayerData == null) {
            this.getPlayerTeamData(this.level());
        }
        if (this.teamPlayerData != null && (this.lastOwnerChange < 0L || this.lastOwnerChange <= this.teamPlayerData.lastChangeTime())) {
            this.cachedTeamOwner = this.teamPlayerData.getPlayerForTeam(this.getClayTeamType());
            this.lastOwnerChange = this.teamPlayerData.lastChangeTime();
        }
        return Optional.ofNullable(this.cachedTeamOwner);
    }

    @Override
    public boolean tryClaimingTeam(Player player) {
        if (!this.getClayTeam().canBeUsed(player)) {
            return false;
        }
        return this.teamPlayerData != null && this.teamPlayerData.putPlayerIfAbsent(this.getClayTeamType(), player);
    }

    @Override
    public boolean unableToMoveToOwner() {
        return TeamHolder.super.unableToMoveToOwner();
    }

    protected void setDataFlag(int pMask, boolean pValue) {
        int i = ((Byte)this.entityData.get(DATA_FLAGS_ID)).byteValue();
        i = pValue ? (i |= pMask) : (i &= ~pMask);
        this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    protected boolean getDataFlag(int pMask) {
        byte i = (Byte)this.entityData.get(DATA_FLAGS_ID);
        return (i & pMask) != 0;
    }

    @Override
    public boolean isOrderedToSit() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)livingEntity;
            return clayMob.orderedToSit;
        }
        return this.orderedToSit;
    }

    @Override
    public void setOrderedToSit(boolean sit) {
        this.orderedToSit = sit;
    }

    @Override
    public boolean isInSittingPose() {
        return this.getDataFlag(1);
    }

    @Override
    public void setInSittingPose(boolean sitting) {
        this.setDataFlag(1, sitting);
    }

    @Nullable
    public ItemStack getPickResult() {
        if (this.spawnedFrom == null || this.spawnedFrom.isEmpty()) {
            return null;
        }
        ItemStack copy = this.spawnedFrom.copy();
        this.modifyPickResult(copy);
        return copy;
    }

    protected void modifyPickResult(ItemStack stack) {
    }

    @Nullable
    public Component getWorkStatus() {
        if (this.isInSittingPose()) {
            return Component.translatable((String)"clay_mob_status.csr.sitting");
        }
        return this.usingPoi() ? Component.literal((String)"clay_mob_status.csr.using_poi") : null;
    }

    public boolean tryToTeleportToOwner() {
        Player livingentity = this.getClayTeamOwner();
        if (livingentity != null) {
            return this.teleportToAroundBlockPos(livingentity.blockPosition());
        }
        return false;
    }

    private boolean teleportToAroundBlockPos(BlockPos p_350657_) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-3, 3);
            int k = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(p_350657_.getX() + j, p_350657_.getY() + l, p_350657_.getZ() + k)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        ClayMobEntity moving;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            v0 = mob;
        } else {
            v0 = moving = this;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z), (Mob)moving)) {
            return false;
        }
        moving.teleportTo((double)x + 0.5, y, (double)z + 0.5);
        moving.getNavigation().stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos, Mob moving) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)moving, (BlockPos)pos);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = moving.level().getBlockState(pos.below());
        if (!this.canFlyToOwner() && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)moving.blockPosition());
        return moving.level().noCollision((Entity)moving, moving.getBoundingBox().move(blockpos));
    }

    protected boolean canFlyToOwner() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)entity;
            return clayMob.canFlyToOwner();
        }
        return false;
    }

    public boolean shouldTryTeleportToOwner() {
        return false;
    }

    public void sendSpawnPayload(ServerPlayer tracking) {
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.sendSpawnPayload(serverPlayer);
    }

    public void setWaxed(boolean waxed) {
        this.setDataFlag(2, waxed);
    }

    public boolean isWaxed() {
        return this.getDataFlag(2);
    }

    @Nullable
    public BlockPos getPoiPos() {
        return this.poiPos;
    }

    public void setPoiPos(@Nullable BlockPos pos) {
        this.poiPos = pos;
        boolean hasPos = pos != null;
        this.entityData.set(HAS_POI_POS, (Object)hasPos);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.poiPosCapability = hasPos ? UseAssignedPoiGoal.createCache(this, serverLevel) : null;
        }
    }

    @Nullable
    public AssignablePoiCapability getPoiCapability() {
        return this.poiPosCapability == null ? null : this.poiPosCapability.getCapability();
    }

    public void setUsingPoi(boolean usingPoi) {
        this.entityData.set(USING_POI, (Object)usingPoi);
    }

    public boolean usingPoi() {
        return (Boolean)this.entityData.get(USING_POI);
    }

    protected boolean hasPoiPos() {
        return (Boolean)this.entityData.get(HAS_POI_POS);
    }

    protected void doPush(Entity entity) {
        if (entity instanceof Player) {
            return;
        }
        super.doPush(entity);
    }

    protected void playAttackSound() {
        this.playSound(SoundEvents.MUD_BRICKS_HIT, 0.3f, 1.0f);
    }

    public List<String> getInfoState() {
        ArrayList<String> info = new ArrayList<String>(4);
        info.add("TeamPlayerData: " + String.valueOf(this.teamPlayerData));
        info.add("CachedTeam: " + String.valueOf(this.cachedTeam));
        info.add("Owner: " + String.valueOf(this.cachedTeamOwner == null ? "Null" : this.cachedTeamOwner));
        info.add("PoiPos: " + String.valueOf(this.poiPos) + " PoiCap: " + String.valueOf(this.poiPosCapability));
        info.add("Active Goals:");
        this.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).map(g -> g.getGoal().getClass().getSimpleName()).forEach(c -> info.add(" - " + c));
        return info;
    }

    @FunctionalInterface
    protected static interface DamageCalculator {
        public float calculate(boolean var1, @Nullable Entity var2);
    }
}

