/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayMobSpawnPayload;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ClayMobTeamOwnerEntity
extends ClayMobEntity {
    private static final EntityDataAccessor<String> VARIANT_SYNC = SynchedEntityData.defineId(ClayMobTeamOwnerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    @Nullable
    private ResourceLocation teamBeforeChange = null;

    protected ClayMobTeamOwnerEntity(EntityType<? extends ClayMobEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT_SYNC, (Object)ClayMobTeamManger.DEFAULT_TYPE.toString());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        ResourceLocation team = ClayMobTeam.read(pCompound);
        if (!ClayMobTeamManger.isValidTeam(team, this.registryAccess())) {
            ClayMobTeamManger.LOGGER.error("{} was saved with a Team ({}) that does not exist anymore", (Object)this.getClass().getSimpleName(), (Object)team);
            this.setClayTeamType(ClayMobTeamManger.DEFAULT_TYPE);
        } else {
            this.setClayTeamType(team);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        ClayMobTeam.save(this.getClayTeamType(), pCompound);
    }

    @Override
    public ResourceLocation getClayTeamType() {
        return ResourceLocation.parse((String)((String)this.entityData.get(VARIANT_SYNC)));
    }

    @Override
    public void setClayTeamType(ResourceLocation type) {
        if (this.getClayTeamType().equals((Object)type)) {
            return;
        }
        ClayMobTeamManger.getOptional(type, (HolderLookup.Provider)this.registryAccess()).ifPresent(team -> {
            this.entityData.set(VARIANT_SYNC, (Object)type.toString());
            this.level().broadcastEntityEvent((Entity)this, (byte)77);
            this.handleTeamChange(type);
        });
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 77) {
            this.teamBeforeChange = this.getClayTeamType();
            return;
        }
        super.handleEntityEvent(id);
    }

    public void tick() {
        ResourceLocation teamId;
        super.tick();
        if (this.teamBeforeChange != null && this.level().isClientSide() && this.tickCount % 5 == 0 && !(teamId = this.getClayTeamType()).equals((Object)this.teamBeforeChange)) {
            this.teamBeforeChange = null;
            this.handleTeamChange(teamId);
        }
    }

    protected abstract void handleTeamChange(ResourceLocation var1);

    @Override
    public void sendSpawnPayload(ServerPlayer tracking) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)this, new ClayMobSpawnPayload(this));
    }

    protected abstract boolean targetPredicate(LivingEntity var1);
}

