/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.VampiricClayMob;
import net.bumblebee.claysoldiers.entity.goal.ClayMobSitGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClayWraithEntity
extends ClayMobTeamOwnerEntity
implements ClaySoldierLike,
VampiricClayMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double WRAITH_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    public static final float FLAP_DEGREES_PER_TICK = 45.836624f;
    public static final int TICKS_PER_FLAP = Mth.ceil((float)3.9269907f);
    public static final float WRAITH_SCALE = 0.5f;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(ClayWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int FLAG_IS_CHARGING = 1;
    private static final byte MIN_LIFE_SPAN = 0;
    private static final byte MAX_LIFE_SPAN = 63;
    public static final String WRAITH_ATTACK_TAG = "WraithAttacks";
    public static final String LIFE_TICKS_TAG = "LifeTicks";
    public static final String MAX_LIFE_TICKS_TAG = "MaxLifeTicks";
    @Nullable
    private BlockPos boundOrigin;
    private int maxLimitedLifeTicks = -1;
    private int limitedLifeTicks;
    private List<SpecialAttack<?>> attackFunctions = List.of();

    public ClayWraithEntity(EntityType<? extends ClayMobEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new WraithMovementControl(this);
    }

    public boolean isFlapping() {
        return this.tickCount % TICKS_PER_FLAP == 0;
    }

    public static AttributeSupplier setWraithAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 2.5).add(Attributes.ATTACK_SPEED, 0.1).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new WraithSitGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WraithChargeAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new WraithRandomMoveGoal());
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractClaySoldierEntity.class, false, this::targetPredicate));
    }

    @Override
    protected boolean targetPredicate(LivingEntity other) {
        if (!(other instanceof ClayMobEntity)) {
            return false;
        }
        ClayMobEntity target = (ClayMobEntity)other;
        return this.shouldAttackTeamHolder(target);
    }

    @Override
    protected double getDefaultAttackReach() {
        return WRAITH_ATTACK_REACH;
    }

    @Override
    protected void handleTeamChange(ResourceLocation teamId) {
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        this.checkInsideBlocks();
    }

    @Override
    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (!this.isNightForVampire()) {
            --this.limitedLifeTicks;
        }
        if (this.hasLimitedLife() && this.limitedLifeTicks <= 0) {
            this.updateLifePercent();
            this.kill();
        }
        if (!this.level().isClientSide && this.hasLimitedLife() && this.limitedLifeTicks % 5 == 0) {
            this.updateLifePercent();
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.boundOrigin != null) {
            pCompound.putInt("BoundX", this.boundOrigin.getX());
            pCompound.putInt("BoundY", this.boundOrigin.getY());
            pCompound.putInt("BoundZ", this.boundOrigin.getZ());
        }
        if (this.hasLimitedLife()) {
            pCompound.putInt(MAX_LIFE_TICKS_TAG, this.maxLimitedLifeTicks);
            pCompound.putInt(LIFE_TICKS_TAG, this.limitedLifeTicks);
        }
        if (!this.attackFunctions.isEmpty()) {
            ClayWraithEntity.writeSpecialAttackToTag(pCompound, this.attackFunctions);
        }
    }

    public static void writeSpecialAttackToTag(CompoundTag tag, List<SpecialAttack<?>> attacks) {
        SpecialAttack.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, attacks).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(wraithAttack -> tag.put(WRAITH_ATTACK_TAG, wraithAttack));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("BoundX")) {
            this.boundOrigin = new BlockPos(pCompound.getInt("BoundX"), pCompound.getInt("BoundY"), pCompound.getInt("BoundZ"));
        }
        this.readItemPersistentData(pCompound);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    public void setLimitedLife(int pLimitedLifeTicks) {
        this.maxLimitedLifeTicks = pLimitedLifeTicks;
        this.limitedLifeTicks = pLimitedLifeTicks;
    }

    public boolean hasLimitedLife() {
        return this.maxLimitedLifeTicks > 0;
    }

    public int getLimitedLifeTicks() {
        return this.limitedLifeTicks;
    }

    public boolean isCharging() {
        byte i = (Byte)this.entityData.get(DATA_FLAGS_ID);
        return (i & 1) != 0;
    }

    public void setIsCharging(boolean pCharging) {
        int i = ((Byte)this.entityData.get(DATA_FLAGS_ID)).byteValue();
        i = pCharging ? (i |= 1) : (i &= 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public int getLifePoint() {
        return (Byte)this.entityData.get(DATA_FLAGS_ID) >> 1;
    }

    private void updateLifePercent() {
        float percent = this.maxLimitedLifeTicks <= 0 ? 1.0f : (float)this.limitedLifeTicks / (float)this.maxLimitedLifeTicks;
        if (percent < 0.0f) {
            percent = 0.0f;
        } else if (percent > 1.0f) {
            percent = 1.0f;
        }
        byte b = (byte)((this.isCharging() ? (byte)1 : 0) | (byte)((byte)(percent * 63.0f) << 1));
        this.entityData.set(DATA_FLAGS_ID, (Object)b);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.VEX_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VEX_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.VEX_HURT;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    private void doAttackFunctions(LivingEntity target) {
        for (SpecialAttack<?> attack : this.attackFunctions) {
            if (!attack.getAttackType().is(SpecialAttackType.MELEE)) continue;
            attack.performAttackEffect(this, (Entity)target);
        }
    }

    public void setAttackFunctions(List<SpecialAttack<?>> attacks) {
        this.attackFunctions = attacks;
    }

    @Override
    public ClayMobEntity asClayMob() {
        return this;
    }

    @Override
    public <T extends ClaySoldierInventoryHandler> void copyInventory(T toCopyTo) {
    }

    @Override
    public void readItemPersistentData(CompoundTag tag) {
        if (tag.contains(LIFE_TICKS_TAG, 3)) {
            this.limitedLifeTicks = tag.getInt(LIFE_TICKS_TAG);
            this.maxLimitedLifeTicks = Math.max(tag.getInt(MAX_LIFE_TICKS_TAG), this.limitedLifeTicks);
        } else if (tag.contains(LIFE_TICKS_TAG, 8)) {
            CodecUtils.getTimeFromEither((Either<Integer, String>)Either.right((Object)tag.getString(LIFE_TICKS_TAG))).ifSuccess(ticks -> {
                this.limitedLifeTicks = ticks;
                this.maxLimitedLifeTicks = Math.max(tag.getInt(MAX_LIFE_TICKS_TAG), this.limitedLifeTicks);
            }).ifError(err -> LOGGER.error("Error Reading {} for Wraith as Seconds: {}", (Object)LIFE_TICKS_TAG, (Object)err.message()));
        }
        if (tag.contains(WRAITH_ATTACK_TAG, 10)) {
            SpecialAttack.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(WRAITH_ATTACK_TAG)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(specialAttack -> {
                this.attackFunctions = specialAttack;
            });
        }
    }

    @Override
    public float getNightPower() {
        return (this.level().getMoonBrightness() + 1.0f) * 1.5f;
    }

    public float getSpeed() {
        return super.getSpeed() * this.getPowerMultiplier();
    }

    @Nullable
    public static ClayWraithEntity spawnWraith(ServerLevel level, ClayMobEntity caster, int duration) {
        return ClayWraithEntity.spawnWraith(level, caster, duration, true, w -> {});
    }

    @Nullable
    public static ClayWraithEntity spawnWraith(ServerLevel level, ClayMobEntity caster, int duration, Consumer<ClayWraithEntity> onSpawn) {
        return ClayWraithEntity.spawnWraith(level, caster, duration, false, onSpawn);
    }

    @Nullable
    private static ClayWraithEntity spawnWraith(ServerLevel level, ClayMobEntity caster, int duration, boolean summoned, Consumer<ClayWraithEntity> onSpawn) {
        if (duration <= 0) {
            return null;
        }
        BlockPos bound = caster.blockPosition();
        ClayWraithEntity wraith = (ClayWraithEntity)ModEntityTypes.CLAY_WRAITH.get().create(caster.level());
        if (wraith != null) {
            wraith.moveTo(caster.position(), caster.getYRot(), caster.getXRot());
            wraith.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(bound), summoned ? MobSpawnType.MOB_SUMMONED : MobSpawnType.CONVERSION, null);
            wraith.setBoundOrigin(bound);
            wraith.setLimitedLife(20 * (duration + caster.getRandom().nextInt(duration)));
            wraith.setClayTeamType(caster.getClayTeamType());
            level.addFreshEntityWithPassengers((Entity)wraith);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, bound, GameEvent.Context.of((Entity)caster));
            onSpawn.accept(wraith);
        }
        return wraith;
    }

    @Override
    public LevelAccessor getLevel() {
        return this.level();
    }

    class WraithMovementControl
    extends MoveControl {
        public WraithMovementControl(ClayWraithEntity wraith) {
            super((Mob)wraith);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - ClayWraithEntity.this.getX(), this.wantedY - ClayWraithEntity.this.getY(), this.wantedZ - ClayWraithEntity.this.getZ());
                double d0 = vec3.length();
                if (d0 < ClayWraithEntity.this.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    ClayWraithEntity.this.setDeltaMovement(ClayWraithEntity.this.getDeltaMovement().scale(0.5));
                } else {
                    ClayWraithEntity.this.setDeltaMovement(ClayWraithEntity.this.getDeltaMovement().add(vec3.scale(this.speedModifier * 0.05 / d0)));
                    if (ClayWraithEntity.this.getTarget() == null) {
                        Vec3 vec31 = ClayWraithEntity.this.getDeltaMovement();
                        ClayWraithEntity.this.setYRot(-((float)Mth.atan2((double)vec31.x, (double)vec31.z)) * 57.295776f);
                        ClayWraithEntity.this.yBodyRot = ClayWraithEntity.this.getYRot();
                    } else {
                        double d2 = ClayWraithEntity.this.getTarget().getX() - ClayWraithEntity.this.getX();
                        double d1 = ClayWraithEntity.this.getTarget().getZ() - ClayWraithEntity.this.getZ();
                        ClayWraithEntity.this.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        ClayWraithEntity.this.yBodyRot = ClayWraithEntity.this.getYRot();
                    }
                }
            }
        }
    }

    static class WraithSitGoal
    extends ClayMobSitGoal {
        public WraithSitGoal(ClayMobEntity clayMobEntity) {
            super(clayMobEntity);
        }

        @Override
        public boolean canUse() {
            if (this.isCurrentlyFighting()) {
                return false;
            }
            if (this.clayMobEntity.isPassenger()) {
                return false;
            }
            if (this.clayMobEntity.isInWaterOrBubble()) {
                return false;
            }
            Player owner = this.clayMobEntity.getClayTeamOwner();
            if (owner == null) {
                return false;
            }
            return !(this.clayMobEntity.distanceToSqr((Entity)owner) < 144.0 && owner.getLastHurtByMob() != null || !this.clayMobEntity.isOrderedToSit());
        }
    }

    class WraithChargeAttackGoal
    extends Goal {
        public WraithChargeAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity livingentity = ClayWraithEntity.this.getTarget();
            return livingentity != null && livingentity.isAlive() && !ClayWraithEntity.this.getMoveControl().hasWanted() && ClayWraithEntity.this.random.nextInt(WraithChargeAttackGoal.reducedTickDelay((int)7)) == 0 && ClayWraithEntity.this.distanceToSqr((Entity)livingentity) > 4.0;
        }

        public boolean canContinueToUse() {
            return ClayWraithEntity.this.getMoveControl().hasWanted() && ClayWraithEntity.this.isCharging() && ClayWraithEntity.this.getTarget() != null && ClayWraithEntity.this.getTarget().isAlive();
        }

        public void start() {
            LivingEntity livingentity = ClayWraithEntity.this.getTarget();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.getEyePosition();
                ClayWraithEntity.this.moveControl.setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
            }
            ClayWraithEntity.this.setIsCharging(true);
            ClayWraithEntity.this.playSound(SoundEvents.VEX_CHARGE, 1.0f, 1.0f);
        }

        public void stop() {
            ClayWraithEntity.this.setIsCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = ClayWraithEntity.this.getTarget();
            if (target != null) {
                if (ClayWraithEntity.this.getBoundingBox().inflate(2.0).intersects(target.getBoundingBox())) {
                    ClayWraithEntity.this.doHurtTarget((Entity)target);
                    ClayWraithEntity.this.doAttackFunctions(target);
                    ClayWraithEntity.this.setIsCharging(false);
                } else {
                    double distanceToTarget = ClayWraithEntity.this.distanceToSqr((Entity)target);
                    if (distanceToTarget < 9.0) {
                        Vec3 targetPos = target.getEyePosition();
                        ClayWraithEntity.this.moveControl.setWantedPosition(targetPos.x, targetPos.y, targetPos.z, 1.0);
                    }
                }
            }
        }
    }

    class WraithRandomMoveGoal
    extends Goal {
        public WraithRandomMoveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (ClayWraithEntity.this.isOrderedToSit()) {
                return false;
            }
            return !ClayWraithEntity.this.getMoveControl().hasWanted() && ClayWraithEntity.this.random.nextInt(WraithRandomMoveGoal.reducedTickDelay((int)7)) == 0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void tick() {
            BlockPos blockpos = ClayWraithEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = ClayWraithEntity.this.blockPosition();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.offset(ClayWraithEntity.this.random.nextInt(15) - 7, ClayWraithEntity.this.random.nextInt(11) - 5, ClayWraithEntity.this.random.nextInt(15) - 7);
                if (!ClayWraithEntity.this.level().isEmptyBlock(blockpos1)) continue;
                ClayWraithEntity.this.moveControl.setWantedPosition((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 0.25);
                if (ClayWraithEntity.this.getTarget() != null) break;
                ClayWraithEntity.this.getLookControl().setLookAt((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

