/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import com.mojang.serialization.DynamicOps;
import net.bumblebee.claysoldiers.entity.client.ClientClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClayBlockProjectileEntity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Float> BLOCK_SIZE = SynchedEntityData.defineId(ClayBlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> SOLDIER_TEAM_ID = SynchedEntityData.defineId(ClayBlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final BlockState CLAY_BLOCKSTATE = Blocks.CLAY.defaultBlockState();
    private static final String BLOCK_SIZE_TAG = "BlockSize";
    private static final String PIERCE_TAG = "PierceCount";
    private static final String SOLDIER_TEAM_ID_TAG = "soldierTeam";
    private static final String LIFETIME_TAG = "LifeTime";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClayBlockProjectileEntity.class);
    private final DamageSource damageSource;
    @Nullable
    private ClientClaySoldierEntity clientSoldier;
    @Nullable
    private WalkAnimationState walkState;
    public int showParticle = 3;
    public int rot = 0;
    private int pierceCount = 0;
    private int lifeTime = 140;

    public ClayBlockProjectileEntity(EntityType<? extends ClayBlockProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.accelerationPower = 0.02;
        this.damageSource = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(ModDamageTypes.CLAY_HURT).orElseThrow(), (Entity)this, null);
    }

    public ClayBlockProjectileEntity(Level level, LivingEntity owner, Vec3 movement) {
        super(ModEntityTypes.CLAY_BLOCK_PROJECTILE.get(), owner, movement, level);
        this.accelerationPower = 0.02;
        this.damageSource = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(ModDamageTypes.CLAY_HURT).orElseThrow(), (Entity)this, (Entity)owner);
    }

    public ClayBlockProjectileEntity(Level level, LivingEntity owner, float yOffset) {
        super(ModEntityTypes.CLAY_BLOCK_PROJECTILE.get(), owner.getX(), owner.getY() + (double)yOffset, owner.getZ(), level);
        this.accelerationPower = 0.02;
        this.setOwner((Entity)owner);
        this.damageSource = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(ModDamageTypes.CLAY_HURT).orElseThrow(), (Entity)this, (Entity)owner);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getBlockSize() != 1.0f) {
            compound.putFloat(BLOCK_SIZE_TAG, this.getBlockSize());
        }
        if (this.pierceCount > 0) {
            compound.putInt(PIERCE_TAG, this.pierceCount);
        }
        if (this.hasClayTeam()) {
            ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getClayTeam().key().location()).ifSuccess(tag -> compound.put(SOLDIER_TEAM_ID_TAG, tag)).ifError(err -> LOGGER.error("Error saving Clay Team to Tag: {}", (Object)err.message()));
        }
        compound.putInt(LIFETIME_TAG, this.lifeTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(BLOCK_SIZE_TAG, 99)) {
            this.setBlockSize(Math.max(0.2f, compound.getFloat(BLOCK_SIZE_TAG)));
        }
        if (compound.contains(PIERCE_TAG, 3)) {
            this.setPierceCount(compound.getInt(PIERCE_TAG));
        }
        if (compound.contains(SOLDIER_TEAM_ID_TAG)) {
            ResourceLocation.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get(SOLDIER_TEAM_ID_TAG)).ifSuccess(this::setClayTeam).ifError(err -> LOGGER.error("Error reading Clay Team: {}", (Object)err.message()));
        }
        if (compound.contains(LIFETIME_TAG, 3)) {
            this.lifeTime = compound.getInt(LIFETIME_TAG);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLOCK_SIZE, (Object)Float.valueOf(1.0f));
        builder.define(SOLDIER_TEAM_ID, (Object)-1);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity entity = result.getEntity();
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity2;
                boolean didHurt = entity.hurt(this.damageSource, 4.0f * this.getBlockSize());
                if (didHurt) {
                    if (entity.isAlive()) {
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)this.damageSource);
                    } else {
                        livingentity.heal(2.0f);
                    }
                }
            } else {
                entity.hurt(this.damageSources().magic(), 2.5f * this.getBlockSize());
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.onHitEffect(result, false);
    }

    private void onHitEffect(@Nullable HitResult hitResult, boolean forceDelete) {
        if (!this.level().isClientSide()) {
            if (forceDelete || this.pierceCount < 0 || hitResult.getType() == HitResult.Type.BLOCK) {
                if (this.hasClayTeam()) {
                    this.spawnSoldier((ServerLevel)this.level());
                }
                this.discard();
            } else {
                --this.pierceCount;
            }
        } else {
            float particleOffset = 0.08f;
            int i = 0;
            while ((float)i < 5.0f * Math.max(1.0f, this.getBlockSize() * this.getBlockSize())) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, CLAY_BLOCKSTATE), this.getX(), this.getY(), this.getZ(), ((double)this.getRandom().nextFloat() - 0.5) * (double)particleOffset, ((double)this.getRandom().nextFloat() - 0.5) * (double)particleOffset, ((double)this.getRandom().nextFloat() - 0.5) * (double)particleOffset);
                ++i;
            }
        }
    }

    private void spawnSoldier(ServerLevel level) {
        AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)ModEntityTypes.CLAY_SOLDIER_ENTITY.get().create((Level)level);
        if (soldier != null) {
            Vec3 pos = this.position();
            ResourceLocation team = this.getClayTeam().key().location();
            soldier.setClayTeamType(team);
            soldier.setPos(pos);
            soldier.setSpawnedFrom(ClayMobTeamManger.createStackForTeam(team, (HolderLookup.Provider)level.registryAccess()), false);
            soldier.moveTo(pos, this.getYRot(), this.getXRot());
            soldier.yHeadRot = soldier.getYRot();
            soldier.yBodyRot = soldier.getYRot();
            soldier.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(soldier.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            level.addFreshEntity((Entity)soldier);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        if (this.showParticle++ >= 3) {
            this.showParticle = 0;
            return new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.CLAY.defaultBlockState());
        }
        return null;
    }

    public void setBlockSize(float size) {
        this.entityData.set(BLOCK_SIZE, (Object)Float.valueOf(size));
    }

    public float getBlockSize() {
        return ((Float)this.entityData.get(BLOCK_SIZE)).floatValue();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (BLOCK_SIZE.equals(key)) {
            this.refreshDimensions();
        }
        if (SOLDIER_TEAM_ID.equals(key) && this.level().isClientSide()) {
            Holder.Reference<ClayMobTeam> holder = this.getClayTeam();
            if (holder != null) {
                this.walkState = new WalkAnimationState();
                this.clientSoldier = ClientClaySoldierEntity.createAsProjectile(this.walkState, holder);
            } else {
                this.clientSoldier = null;
                this.walkState = null;
            }
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale(this.getBlockSize());
    }

    public void setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
    }

    public void setClayTeam(ResourceLocation id) {
        ClayMobTeamManger.getOptional(id, (HolderLookup.Provider)this.registryAccess()).ifPresentOrElse(team -> this.entityData.set(SOLDIER_TEAM_ID, (Object)this.registryAccess().registryOrThrow(ModRegistries.CLAY_MOB_TEAMS).getId(team)), () -> LOGGER.error("Error Setting Team {} for Clay Block Projectile", (Object)id));
    }

    public boolean hasClayTeam() {
        return (Integer)this.entityData.get(SOLDIER_TEAM_ID) >= 0;
    }

    @Nullable
    private Holder.Reference<ClayMobTeam> getClayTeam() {
        Registry reg = this.registryAccess().registryOrThrow(ModRegistries.CLAY_MOB_TEAMS);
        return reg.getHolder(((Integer)this.entityData.get(SOLDIER_TEAM_ID)).intValue()).orElse(null);
    }

    @Nullable
    public ClientClaySoldierEntity getClientSoldier() {
        return this.clientSoldier;
    }

    public void clientTick(float partialTick) {
        if (this.walkState != null) {
            float f = Math.min(partialTick * 4.0f, 1.0f);
            this.walkState.update(f, 0.4f);
        }
    }

    public void tick() {
        super.tick();
        --this.lifeTime;
        if (this.lifeTime <= 0) {
            this.onHitEffect(null, true);
        }
    }
}

