/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.AvoidSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.EscapeSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;

public class SmartBossClaySoldierEntity
extends BossClaySoldierEntity
implements SmartBrainOwner<SmartBossClaySoldierEntity> {
    public SmartBossClaySoldierEntity(EntityType<? extends BossClaySoldierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends SmartBossClaySoldierEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new HurtBySensor(), new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPredicate((LivingEntity)target))});
    }

    public BrainActivityGroup<? extends SmartBossClaySoldierEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTargetSink(40, 300), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<? extends SmartBossClaySoldierEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new AvoidSun(), new EscapeSun().cooldownFor(entity -> 20)}).startCondition(BossClaySoldierEntity::isUndead), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().walkTargetPredicate(BossClaySoldierEntity::shouldWalkToTarget).avoidWaterWhen(BossClaySoldierEntity::isVampire), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    public BrainActivityGroup<? extends SmartBossClaySoldierEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new AnimatableRangedAttack(20).cooldownFor(s -> 60), new AnimatableMeleeAttack(0).whenActivating(AbstractClaySoldierEntity::indicateMeleeItemUse).whenStarting(entity -> this.setAggressive(true)).whenStopping(entity -> this.setAggressive(false))})});
    }
}

