/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierArmorLayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.WaxedRenderLayer;
import net.bumblebee.claysoldiers.entity.client.accesories.AccessoryRenderLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractClaySoldierRenderer
extends HumanoidMobRenderer<AbstractClaySoldierEntity, ClaySoldierModel> {
    private static final float SCALE = 0.25f;
    private final ItemInHandRenderer itemInHandRenderer;

    protected AbstractClaySoldierRenderer(EntityRendererProvider.Context pContext, ClaySoldierModel model) {
        super(pContext, (HumanoidModel)model, 0.125f, 0.25f, 0.25f, 0.25f);
        this.layers.removeIf(layer -> layer.getClass() == CustomHeadLayer.class || layer.getClass() == ItemInHandLayer.class);
        this.itemInHandRenderer = pContext.getItemInHandRenderer();
        this.addLayer(new ClaySoldierArmorLayer((RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel>)this, new ClaySoldierModel(pContext.bakeLayer(ModelLayers.ZOMBIE_INNER_ARMOR)), new ClaySoldierModel(pContext.bakeLayer(ModelLayers.ZOMBIE_OUTER_ARMOR)), pContext.getModelManager(), pContext.getItemRenderer()));
        this.addLayer(new AccessoryRenderLayer((RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel>)this, pContext.getModelSet(), this.itemInHandRenderer, pContext.getItemRenderer()));
        this.addLayer(new ClayMobStatusRenderlayer(this, pContext.getEntityRenderDispatcher(), pContext.getItemRenderer()));
        this.addLayer(new WaxedRenderLayer(this));
        this.addLayer((RenderLayer)new ClaySoldierItemInHandLayer((RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel>)this, this.itemInHandRenderer));
    }

    protected void scale(AbstractClaySoldierEntity claySoldier, PoseStack poseStack, float partialTickTime) {
        poseStack.scale(0.25f, 0.25f, 0.25f);
        this.scaleExplode(claySoldier, poseStack, partialTickTime);
    }

    public void render(AbstractClaySoldierEntity claySoldier, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        boolean shouldGlow;
        boolean bodyVisible;
        Direction direction;
        Entity vehicle;
        boolean shouldSit;
        pPoseStack.pushPose();
        ((ClaySoldierModel)this.model).attackTime = this.getAttackAnim((LivingEntity)claySoldier, pPartialTicks);
        ((ClaySoldierModel)this.model).riding = shouldSit = claySoldier.isPassenger() && claySoldier.getVehicle() != null && ClaySoldiersCommon.COMMON_HOOKS.shouldRiderSit(claySoldier.getVehicle());
        ((ClaySoldierModel)this.model).young = claySoldier.isBaby();
        float yBodyRot = Mth.rotLerp((float)pPartialTicks, (float)claySoldier.yBodyRotO, (float)claySoldier.yBodyRot);
        float yHeadRot = Mth.rotLerp((float)pPartialTicks, (float)claySoldier.yHeadRotO, (float)claySoldier.yHeadRot);
        float netHeadYaw = yHeadRot - yBodyRot;
        if (shouldSit && claySoldier.getVehicle() instanceof LivingEntity && (vehicle = claySoldier.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)vehicle;
            yBodyRot = Mth.rotLerp((float)pPartialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            netHeadYaw = yHeadRot - yBodyRot;
            float f6 = Mth.wrapDegrees((float)netHeadYaw);
            if (f6 < -85.0f) {
                f6 = -85.0f;
            }
            if (f6 >= 85.0f) {
                f6 = 85.0f;
            }
            yBodyRot = yHeadRot - f6;
            if (f6 * f6 > 2500.0f) {
                yBodyRot += f6 * 0.2f;
            }
            netHeadYaw = yHeadRot - yBodyRot;
        }
        float headPitch = Mth.lerp((float)pPartialTicks, (float)claySoldier.xRotO, (float)claySoldier.getXRot());
        if (AbstractClaySoldierRenderer.isEntityUpsideDown((LivingEntity)claySoldier)) {
            headPitch *= -1.0f;
            netHeadYaw *= -1.0f;
        }
        netHeadYaw = Mth.wrapDegrees((float)netHeadYaw);
        if (claySoldier.hasPose(Pose.SLEEPING) && (direction = claySoldier.getBedOrientation()) != null) {
            float f3 = claySoldier.getEyeHeight(Pose.STANDING) - 0.1f;
            pPoseStack.translate((float)(-direction.getStepX()) * f3, 0.0f, (float)(-direction.getStepZ()) * f3);
        }
        float ageInTicks = this.getBob((LivingEntity)claySoldier, pPartialTicks);
        float scale = claySoldier.getScale();
        pPoseStack.scale(scale, scale, scale);
        this.setupRotations((LivingEntity)claySoldier, pPoseStack, ageInTicks, yBodyRot, pPartialTicks, 1.0f);
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(claySoldier, pPoseStack, pPartialTicks);
        pPoseStack.translate(0.0f, -1.501f, 0.0f);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && claySoldier.isAlive()) {
            limbSwingAmount = claySoldier.getWalkAnimation().speed(pPartialTicks);
            limbSwing = claySoldier.getWalkAnimation().position(pPartialTicks);
            if (claySoldier.isBaby()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        ((ClaySoldierModel)this.model).prepareMobModel((LivingEntity)claySoldier, limbSwing, limbSwingAmount, pPartialTicks);
        ((ClaySoldierModel)this.model).setupAnim(claySoldier, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (claySoldier.getRidingPose() == AbstractClaySoldierEntity.RidingPose.FIREWORK) {
            pPoseStack.translate(0.0, 0.5, 0.0);
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean isInvisible = !(bodyVisible = this.isBodyVisible(claySoldier));
        RenderType rendertype = this.getRenderType((LivingEntity)claySoldier, bodyVisible, isInvisible, shouldGlow = minecraft.shouldEntityAppearGlowing((Entity)claySoldier));
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(rendertype);
            int overlay = AbstractClaySoldierRenderer.getOverlayCoords((LivingEntity)claySoldier, (float)this.getWhiteOverlayProgress(claySoldier, pPartialTicks));
            ClayMobTeam variant = this.getVariantForColor(claySoldier);
            this.renderModel(claySoldier, pPoseStack, vertexconsumer, pPackedLight, overlay, variant.getColor((LivingEntity)claySoldier, pPartialTicks), isInvisible ? 38 : 255);
        }
        for (RenderLayer renderlayer : this.layers) {
            renderlayer.render(pPoseStack, pBuffer, pPackedLight, (Entity)claySoldier, limbSwing, limbSwingAmount, pPartialTicks, ageInTicks, netHeadYaw, headPitch);
        }
        this.renderCarried(claySoldier, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.popPose();
        if (this.shouldShowName((Mob)claySoldier)) {
            this.renderNameTag((Entity)claySoldier, claySoldier.getDisplayName(), pPoseStack, pBuffer, pPackedLight, pPartialTicks);
        }
    }

    protected void renderModel(AbstractClaySoldierEntity soldier, PoseStack pPoseStack, VertexConsumer vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        ((ClaySoldierModel)this.model).renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, overlayCords, FastColor.ARGB32.color((int)alpha, (int)color));
    }

    protected ClayMobTeam getVariantForColor(AbstractClaySoldierEntity claySoldier) {
        return claySoldier.getClayTeam();
    }

    private void renderCarried(AbstractClaySoldierEntity soldier, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (!soldier.getCarriedStack().isEmpty()) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, -0.55, 0.0);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(135.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.scale(1.5f, 1.5f, 1.5f);
            this.itemInHandRenderer.renderItem((LivingEntity)soldier, soldier.getCarriedStack(), ItemDisplayContext.FIXED, false, pPoseStack, pBuffer, pPackedLight);
            pPoseStack.popPose();
        }
    }

    private void scaleExplode(AbstractClaySoldierEntity claySoldier, PoseStack pPoseStack, float pPartialTickTime) {
        float swelling = claySoldier.getSwelling(pPartialTickTime);
        float f1 = 1.0f + Mth.sin((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = Mth.clamp((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float f2 = (1.0f + swelling * 0.4f) * f1;
        float f3 = (1.0f + swelling * 0.1f) / f1;
        pPoseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(AbstractClaySoldierEntity claySoldier, float pPartialTicks) {
        float swelling = claySoldier.getSwelling(pPartialTicks);
        return (int)(swelling * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)swelling, (float)0.5f, (float)1.0f);
    }

    protected int getBlockLightLevel(AbstractClaySoldierEntity pEntity, BlockPos pPos) {
        return pEntity.allProperties().isGlowing() ? 15 : super.getBlockLightLevel((Entity)pEntity, pPos);
    }

    protected boolean isBodyVisible(AbstractClaySoldierEntity livingEntity) {
        return super.isBodyVisible((LivingEntity)livingEntity) && !livingEntity.allProperties().isInvisible();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private static class ClaySoldierItemInHandLayer
    extends ItemInHandLayer<AbstractClaySoldierEntity, ClaySoldierModel> {
        public ClaySoldierItemInHandLayer(RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel> renderer, ItemInHandRenderer itemInHandRenderer) {
            super(renderer, itemInHandRenderer);
        }

        protected void renderArmWithItem(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
            if (arm == HumanoidArm.LEFT && ((AbstractClaySoldierEntity)livingEntity).handsOccupied(SoldierEquipmentSlot.OFFHAND)) {
                return;
            }
            if (arm == HumanoidArm.RIGHT && ((AbstractClaySoldierEntity)livingEntity).handsOccupied(SoldierEquipmentSlot.MAINHAND)) {
                return;
            }
            super.renderArmWithItem(livingEntity, itemStack, displayContext, arm, poseStack, buffer, packedLight);
        }
    }
}

