/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ClayMobStatusRenderlayer<E extends ClayMobEntity, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    private final MobRenderer<E, M> parent;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemRenderer itemRenderer;

    public ClayMobStatusRenderlayer(MobRenderer<E, M> renderer, EntityRenderDispatcher entityRenderDispatcher, ItemRenderer itemRenderer) {
        super(renderer);
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.parent = renderer;
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ClayMobEntity clayMobEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.shouldShowStatus(clayMobEntity) || clayMobEntity.isVehicle()) {
            return;
        }
        Component workStatus = clayMobEntity.getWorkStatus();
        if (workStatus == null) {
            return;
        }
        PoseStack.Pose lastPose = poseStack.last().copy();
        poseStack.popPose();
        this.renderStatus(clayMobEntity, poseStack, buffer, packedLight, partialTick, workStatus);
        poseStack.pushPose();
        poseStack.setIdentity();
        poseStack.mulPose(lastPose.pose());
    }

    private void renderStatus(ClayMobEntity soldier, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, float pPartialTick, Component workStatus) {
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        if (!soldier.isInSittingPose()) {
            pPoseStack.translate(0.0, 0.45, 0.0);
        } else {
            pPoseStack.translate(0.0, 0.35, 0.0);
        }
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        pPoseStack.translate(0.0, 0.45, 0.0);
        this.renderStatus(soldier, workStatus, pPoseStack, pBuffer, pPackedLight, pPartialTick);
        pPoseStack.popPose();
    }

    private boolean shouldShowStatus(ClayMobEntity soldier) {
        LocalPlayer player = Minecraft.getInstance().player;
        return player.equals((Object)soldier.getClayTeamOwner()) && ClaySoldiersClient.hasPlayerClayGogglesEquipped();
    }

    private void renderStatus(ClayMobEntity entity, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTick) {
        Vec3 vec3;
        double distanceToSqr = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        if (ClaySoldiersClient.CLIENT_HOOKS.isNameplateInRenderDistance((Entity)entity, distanceToSqr) && (vec3 = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getViewYRot(partialTick))) != null) {
            boolean isClayDiscrete = !entity.isDiscrete();
            poseStack.pushPose();
            poseStack.translate(vec3.x, vec3.y + 0.5, vec3.z);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int backGroundColor = (int)(f * 255.0f) << 24;
            Font font = this.parent.getFont();
            float f1 = -font.width((FormattedText)displayName) / 2;
            font.drawInBatch(displayName, f1, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, isClayDiscrete ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backGroundColor, packedLight);
            if (isClayDiscrete) {
                font.drawInBatch(displayName, f1, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            }
            poseStack.popPose();
        }
    }
}

