/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.horse;

import com.google.common.collect.ImmutableList;
import net.bumblebee.claysoldiers.entity.horse.AbstractClayHorse;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ClayHorseModel
extends AgeableListModel<AbstractClayHorse> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_horse"), "main");
    private static final float DEG_125 = 2.1816616f;
    private static final float DEG_30 = 0.5235988f;
    private static final float DEG_90 = 1.5707964f;
    protected static final String HEAD_PARTS = "head_parts";
    private static final String LEFT_HIND_BABY_LEG = "left_hind_baby_leg";
    private static final String RIGHT_HIND_BABY_LEG = "right_hind_baby_leg";
    private static final String LEFT_FRONT_BABY_LEG = "left_front_baby_leg";
    private static final String RIGHT_FRONT_BABY_LEG = "right_front_baby_leg";
    private static final String SADDLE = "saddle";
    private static final String LEFT_SADDLE_MOUTH = "left_saddle_mouth";
    private static final String LEFT_SADDLE_LINE = "left_saddle_line";
    private static final String RIGHT_SADDLE_MOUTH = "right_saddle_mouth";
    private static final String RIGHT_SADDLE_LINE = "right_saddle_line";
    private static final String HEAD_SADDLE = "head_saddle";
    private static final String MOUTH_SADDLE_WRAP = "mouth_saddle_wrap";
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public ClayHorseModel(ModelPart pRoot) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.body = pRoot.getChild("body");
        this.headParts = pRoot.getChild(HEAD_PARTS);
        this.rightHindLeg = pRoot.getChild("right_hind_leg");
        this.leftHindLeg = pRoot.getChild("left_hind_leg");
        this.rightFrontLeg = pRoot.getChild("right_front_leg");
        this.leftFrontLeg = pRoot.getChild("left_front_leg");
        this.rightHindBabyLeg = pRoot.getChild(RIGHT_HIND_BABY_LEG);
        this.leftHindBabyLeg = pRoot.getChild(LEFT_HIND_BABY_LEG);
        this.rightFrontBabyLeg = pRoot.getChild(RIGHT_FRONT_BABY_LEG);
        this.leftFrontBabyLeg = pRoot.getChild(LEFT_FRONT_BABY_LEG);
        this.tail = this.body.getChild("tail");
        ModelPart modelpart = this.body.getChild(SADDLE);
        ModelPart modelpart1 = this.headParts.getChild(LEFT_SADDLE_MOUTH);
        ModelPart modelpart2 = this.headParts.getChild(RIGHT_SADDLE_MOUTH);
        ModelPart modelpart3 = this.headParts.getChild(LEFT_SADDLE_LINE);
        ModelPart modelpart4 = this.headParts.getChild(RIGHT_SADDLE_LINE);
        ModelPart modelpart5 = this.headParts.getChild(HEAD_SADDLE);
        ModelPart modelpart6 = this.headParts.getChild(MOUTH_SADDLE_WRAP);
        this.saddleParts = new ModelPart[]{modelpart, modelpart1, modelpart2, modelpart5, modelpart6};
        this.ridingParts = new ModelPart[]{modelpart3, modelpart4};
    }

    public static LayerDefinition createLayerDefinition() {
        return LayerDefinition.create((MeshDefinition)ClayHorseModel.createBodyMesh(new CubeDeformation(0.25f)), (int)64, (int)64);
    }

    public static LayerDefinition createLayerArmorDefinition() {
        return LayerDefinition.create((MeshDefinition)ClayHorseModel.createBodyMesh(new CubeDeformation(0.275f)), (int)64, (int)64);
    }

    private static MeshDefinition createBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)11.0f, (float)5.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild(HEAD_PARTS, CubeListBuilder.create().texOffs(0, 35).addBox(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, cubeDeformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, cubeDeformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-12.0f));
        CubeDeformation cubedeformation = cubeDeformation.extend(0.0f, 5.5f, 0.0f);
        partdefinition.addOrReplaceChild(LEFT_HIND_BABY_LEG, CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild(RIGHT_HIND_BABY_LEG, CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild(LEFT_FRONT_BABY_LEG, CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild(RIGHT_FRONT_BABY_LEG, CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubedeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)-12.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(42, 36).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition1.addOrReplaceChild(SADDLE, CubeListBuilder.create().texOffs(26, 0).addBox(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition2.addOrReplaceChild(LEFT_SADDLE_MOUTH, CubeListBuilder.create().texOffs(29, 5).addBox(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild(RIGHT_SADDLE_MOUTH, CubeListBuilder.create().texOffs(29, 5).addBox(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        partdefinition2.addOrReplaceChild(LEFT_SADDLE_LINE, CubeListBuilder.create().texOffs(32, 2).addBox(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild(RIGHT_SADDLE_LINE, CubeListBuilder.create().texOffs(32, 2).addBox(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild(HEAD_SADDLE, CubeListBuilder.create().texOffs(1, 1).addBox(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.ZERO);
        partdefinition2.addOrReplaceChild(MOUTH_SADDLE_WRAP, CubeListBuilder.create().texOffs(19, 0).addBox(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.ZERO);
        partdefinition3.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(19, 16).addBox(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        partdefinition3.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(19, 16).addBox(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        return meshdefinition;
    }

    public void setupAnim(AbstractClayHorse pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean saddled = pEntity.isSaddled();
        boolean isRidden = pEntity.isVehicle();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.visible = saddled;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.visible = isRidden && saddled;
        }
        this.body.y = 11.0f;
        this.setSittingPose(pEntity);
    }

    private void setSittingPose(AbstractClayHorse horse) {
        if (horse.isInSittingPose() && !horse.isPassenger()) {
            this.rightHindLeg.xRot = -1.5707964f;
            this.leftHindLeg.xRot = -1.5707964f;
            this.rightFrontLeg.xRot = 1.5707964f;
            this.leftFrontLeg.xRot = 1.5707964f;
        }
    }

    public Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void prepareMobModel(AbstractClayHorse pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        float f = Mth.rotLerp((float)pPartialTick, (float)pEntity.yBodyRotO, (float)pEntity.yBodyRot);
        float f1 = Mth.rotLerp((float)pPartialTick, (float)pEntity.yHeadRotO, (float)pEntity.yHeadRot);
        float f2 = Mth.lerp((float)pPartialTick, (float)pEntity.xRotO, (float)pEntity.getXRot());
        float f3 = f1 - f;
        float f4 = f2 * ((float)Math.PI / 180);
        if (f3 > 20.0f) {
            f3 = 20.0f;
        }
        if (f3 < -20.0f) {
            f3 = -20.0f;
        }
        if (pLimbSwingAmount > 0.2f) {
            f4 += Mth.cos((float)(pLimbSwing * 0.8f)) * 0.15f * pLimbSwingAmount;
        }
        float f5 = pEntity.getEatAnim(pPartialTick);
        float f6 = pEntity.getStandAnim(pPartialTick);
        float f7 = 1.0f - f6;
        float f8 = pEntity.getMouthAnim(pPartialTick);
        boolean flag = pEntity.tailCounter != 0;
        float f9 = (float)pEntity.tickCount + pPartialTick;
        this.headParts.y = 4.0f;
        this.headParts.z = -12.0f;
        this.body.xRot = 0.0f;
        this.headParts.xRot = 0.5235988f + f4;
        this.headParts.yRot = f3 * ((float)Math.PI / 180);
        float f10 = pEntity.isInWater() ? 0.2f : 1.0f;
        float f11 = Mth.cos((float)(f10 * pLimbSwing * 0.6662f + (float)Math.PI));
        float f12 = f11 * 0.8f * pLimbSwingAmount;
        float f13 = (1.0f - Math.max(f6, f5)) * (0.5235988f + f4 + f8 * Mth.sin((float)f9) * 0.05f);
        this.headParts.xRot = f6 * (0.2617994f + f4) + f5 * (2.1816616f + Mth.sin((float)f9) * 0.05f) + f13;
        this.headParts.yRot = f6 * f3 * ((float)Math.PI / 180) + (1.0f - Math.max(f6, f5)) * this.headParts.yRot;
        this.headParts.y = f6 * -4.0f + f5 * 11.0f + (1.0f - Math.max(f6, f5)) * this.headParts.y;
        this.headParts.z = f6 * -4.0f + f5 * -12.0f + (1.0f - Math.max(f6, f5)) * this.headParts.z;
        this.body.xRot = f6 * -0.7853982f + f7 * this.body.xRot;
        float f14 = 0.2617994f * f6;
        float f15 = Mth.cos((float)(f9 * 0.6f + (float)Math.PI));
        this.leftFrontLeg.y = 2.0f * f6 + 14.0f * f7;
        this.leftFrontLeg.z = -6.0f * f6 - 10.0f * f7;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        float f16 = (-1.0471976f + f15) * f6 + f12 * f7;
        float f17 = (-1.0471976f - f15) * f6 - f12 * f7;
        this.leftHindLeg.xRot = f14 - f11 * 0.5f * pLimbSwingAmount * f7;
        this.rightHindLeg.xRot = f14 + f11 * 0.5f * pLimbSwingAmount * f7;
        this.leftFrontLeg.xRot = f16;
        this.rightFrontLeg.xRot = f17;
        this.tail.xRot = 0.5235988f + pLimbSwingAmount * 0.75f;
        this.tail.y = -5.0f + pLimbSwingAmount;
        this.tail.z = 2.0f + pLimbSwingAmount * 2.0f;
        this.tail.yRot = flag ? Mth.cos((float)(f9 * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.y = this.rightHindLeg.y;
        this.rightHindBabyLeg.z = this.rightHindLeg.z;
        this.rightHindBabyLeg.xRot = this.rightHindLeg.xRot;
        this.leftHindBabyLeg.y = this.leftHindLeg.y;
        this.leftHindBabyLeg.z = this.leftHindLeg.z;
        this.leftHindBabyLeg.xRot = this.leftHindLeg.xRot;
        this.rightFrontBabyLeg.y = this.rightFrontLeg.y;
        this.rightFrontBabyLeg.z = this.rightFrontLeg.z;
        this.rightFrontBabyLeg.xRot = this.rightFrontLeg.xRot;
        this.leftFrontBabyLeg.y = this.leftFrontLeg.y;
        this.leftFrontBabyLeg.z = this.leftFrontLeg.z;
        this.leftFrontBabyLeg.xRot = this.leftFrontLeg.xRot;
        boolean isBaby = pEntity.isBaby();
        this.rightHindLeg.visible = !isBaby;
        this.leftHindLeg.visible = !isBaby;
        this.rightFrontLeg.visible = !isBaby;
        this.leftFrontLeg.visible = !isBaby;
        this.rightHindBabyLeg.visible = isBaby;
        this.leftHindBabyLeg.visible = isBaby;
        this.rightFrontBabyLeg.visible = isBaby;
        this.leftFrontBabyLeg.visible = isBaby;
        this.body.y = isBaby ? 10.8f : 0.0f;
    }
}

