/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.horse;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.horse.AbstractClayHorse;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ClayHorseWingsModel
extends EntityModel<AbstractClayHorse> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_horse_wings"), "main");
    private static final float SCALE = 0.25f;
    private static final CubeDeformation SHRINK_DEFORMATION = new CubeDeformation(0.25f, 0.0f, 0.25f);
    private final ModelPart wings;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public ClayHorseWingsModel(ModelPart root) {
        this.wings = root.getChild("wings");
        this.leftWing = this.wings.getChild("left_wing");
        this.rightWing = this.wings.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wings = partdefinition.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        wings.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(-22, 0).mirror().addBox(-16.0f, 0.0f, -11.0f, 16.0f, 0.0f, 22.0f, SHRINK_DEFORMATION).mirror(false), PartPose.offset((float)-5.0f, (float)0.0f, (float)-1.0f));
        wings.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(-22, 0).addBox(0.0f, 0.0f, -11.0f, 16.0f, 0.0f, 22.0f, SHRINK_DEFORMATION), PartPose.offset((float)5.0f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setUpWingAnim(AbstractClayHorse pEntity, float pAgeInTicks) {
        this.leftWing.z = 5.0f;
        this.rightWing.z = 5.0f;
        this.leftWing.y = 5.1f;
        this.rightWing.y = 5.1f;
        this.leftWing.zRot = 0.0f;
        this.rightWing.zRot = 0.0f;
        if (pEntity.onGround()) {
            this.leftWing.zRot = 0.85f;
            this.rightWing.zRot = -0.85f;
        } else {
            float timePoint = pAgeInTicks * 56.0f * ((float)Math.PI / 180);
            this.rightWing.zRot = Mth.cos((float)timePoint) * (float)Math.PI * 0.15f;
            this.leftWing.zRot = -this.rightWing.zRot;
        }
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int color) {
        this.wings.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, color);
    }

    public void setupAnim(AbstractClayHorse pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }
}

