/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.undead;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.entity.VampiricClayMob;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class VampireEyesLayer
extends RenderLayer<AbstractClaySoldierEntity, ClaySoldierModel> {
    private static final ResourceLocation EYES_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_soldier/vampire_eyes.png");
    private static final RenderType VAMPIRE_EYES = RenderType.entityTranslucentEmissive((ResourceLocation)EYES_LOCATION);
    private static final RenderType VAMPIRE_EYES_ACTIVE = RenderType.eyes((ResourceLocation)EYES_LOCATION);
    private final Predicate<AbstractClaySoldierEntity> shouldEyesGlow;

    public VampireEyesLayer(RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel> renderer, Predicate<AbstractClaySoldierEntity> shouldEyesGlow) {
        super(renderer);
        this.shouldEyesGlow = shouldEyesGlow;
    }

    public static VampireEyesLayer forVampiricClayMob(RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel> renderer) {
        return new VampireEyesLayer(renderer, soldier -> ((VampiricClayMob)((Object)soldier)).isNightForVampire());
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClaySoldierEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (this.shouldEyesGlow.test(pLivingEntity)) {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(VAMPIRE_EYES_ACTIVE);
            ((ClaySoldierModel)this.getParentModel()).renderToBuffer(pPoseStack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY);
        } else {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(VAMPIRE_EYES);
            ((ClaySoldierModel)this.getParentModel()).renderToBuffer(pPoseStack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)127, (int)0xFFFFFF));
        }
    }
}

