/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.undead;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.undead.SoldierSuitLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;

public class ZombieClaySoldierRenderer
extends ClaySoldierRenderer {
    public ZombieClaySoldierRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.addLayer(SoldierSuitLayer.zombie((RenderLayerParent<AbstractClaySoldierEntity, ClaySoldierModel>)this));
    }

    @Override
    protected void renderModel(AbstractClaySoldierEntity soldier, PoseStack pPoseStack, VertexConsumer vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        super.renderModel(soldier, pPoseStack, vertexConsumer, pPackedLight, overlayCords, ZombieClaySoldierRenderer.shiftColor(color), alpha);
    }

    public static int shiftColor(int color) {
        int red = Math.clamp((long)((color >> 16 & 0xFF) - 25), 0, 255);
        int green = Math.clamp((long)((color >> 8 & 0xFF) + 25), 0, 255);
        int blue = Math.clamp((long)((color & 0xFF) - 25), 0, 255);
        return red << 16 | green << 8 | blue;
    }

    @Override
    protected ClayMobTeam getVariantForColor(AbstractClaySoldierEntity claySoldier) {
        if (claySoldier instanceof ZombieClaySoldierEntity) {
            ZombieClaySoldierEntity zombie = (ZombieClaySoldierEntity)claySoldier;
            return zombie.getPreviousTeam();
        }
        return super.getVariantForColor(claySoldier);
    }
}

