/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.wraith;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.wraith.WraithModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class WraithRenderer
extends MobRenderer<ClayWraithEntity, WraithModel> {
    private static final ResourceLocation WRAITH_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_wraith/wraith.png");
    private static final ResourceLocation WRAITH_CHARGING_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/vex_charging.png");
    private static final float SCALE = 0.5f;

    public WraithRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WraithModel(context.bakeLayer(WraithModel.LAYER_LOCATION)), 0.15f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer(new ClayMobStatusRenderlayer<ClayWraithEntity, WraithModel>(this, context.getEntityRenderDispatcher(), context.getItemRenderer()));
    }

    protected void scale(ClayWraithEntity pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
    }

    public ResourceLocation getTextureLocation(ClayWraithEntity pEntity) {
        return WRAITH_LOCATION;
    }

    protected int getBlockLightLevel(ClayWraithEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(ClayWraithEntity wraith, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        Direction direction;
        Entity vehicle;
        boolean shouldSit;
        pPoseStack.pushPose();
        ((WraithModel)this.model).attackTime = this.getAttackAnim((LivingEntity)wraith, pPartialTicks);
        ((WraithModel)this.model).riding = shouldSit = wraith.isPassenger() && wraith.getVehicle() != null && ClaySoldiersCommon.COMMON_HOOKS.shouldRiderSit(wraith.getVehicle());
        ((WraithModel)this.model).young = wraith.isBaby();
        float bodyRot = Mth.rotLerp((float)pPartialTicks, (float)wraith.yBodyRotO, (float)wraith.yBodyRot);
        float f1 = Mth.rotLerp((float)pPartialTicks, (float)wraith.yHeadRotO, (float)wraith.yHeadRot);
        float f2 = f1 - bodyRot;
        if (shouldSit && wraith.getVehicle() instanceof LivingEntity && (vehicle = wraith.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)vehicle;
            bodyRot = Mth.rotLerp((float)pPartialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - bodyRot;
            float f6 = Mth.wrapDegrees((float)f2);
            if (f6 < -85.0f) {
                f6 = -85.0f;
            }
            if (f6 >= 85.0f) {
                f6 = 85.0f;
            }
            bodyRot = f1 - f6;
            if (f6 * f6 > 2500.0f) {
                bodyRot += f6 * 0.2f;
            }
            f2 = f1 - bodyRot;
        }
        float f5 = Mth.lerp((float)pPartialTicks, (float)wraith.xRotO, (float)wraith.getXRot());
        if (WraithRenderer.isEntityUpsideDown((LivingEntity)wraith)) {
            f5 *= -1.0f;
            f2 *= -1.0f;
        }
        if (wraith.hasPose(Pose.SLEEPING) && (direction = wraith.getBedOrientation()) != null) {
            float f3 = wraith.getEyeHeight(Pose.STANDING) - 0.1f;
            pPoseStack.translate((float)(-direction.getStepX()) * f3, 0.0f, (float)(-direction.getStepZ()) * f3);
        }
        float f7 = this.getBob((LivingEntity)wraith, pPartialTicks);
        float scale = wraith.getScale();
        pPoseStack.scale(scale, scale, scale);
        this.setupRotations((LivingEntity)wraith, pPoseStack, f7, bodyRot, pPartialTicks, 1.0f);
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(wraith, pPoseStack, pPartialTicks);
        pPoseStack.translate(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f4 = 0.0f;
        if (!shouldSit && wraith.isAlive()) {
            f8 = wraith.walkAnimation.speed(pPartialTicks);
            f4 = wraith.walkAnimation.position(pPartialTicks);
            if (wraith.isBaby()) {
                f4 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((WraithModel)this.model).prepareMobModel((Entity)wraith, f4, f8, pPartialTicks);
        ((WraithModel)this.model).setupAnim(wraith, f4, f8, f7, f2, f5);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bodyVisible = this.isBodyVisible((LivingEntity)wraith);
        boolean isInvisible = !bodyVisible;
        boolean shouldGlow = minecraft.shouldEntityAppearGlowing((Entity)wraith);
        RenderType rendertype = this.getRenderType((LivingEntity)wraith, bodyVisible, isInvisible, shouldGlow);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(rendertype);
            int overlay = WraithRenderer.getOverlayCoords((LivingEntity)wraith, (float)this.getWhiteOverlayProgress((LivingEntity)wraith, pPartialTicks));
            ((WraithModel)this.model).renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, overlay, FastColor.ARGB32.color((int)this.getAlpha(wraith), (int)wraith.getClayTeam().getColor((LivingEntity)wraith, pPartialTicks)));
        }
        for (RenderLayer renderlayer : this.layers) {
            renderlayer.render(pPoseStack, pBuffer, pPackedLight, (Entity)wraith, f4, f8, pPartialTicks, f7, f2, f5);
        }
        pPoseStack.popPose();
    }

    private int getAlpha(ClayWraithEntity wraith) {
        return Math.max(0, wraith.getLifePoint() * 3 - 10);
    }
}

