/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class ClayMobFollowTeamOwner
extends Goal {
    private final ClayMobEntity clayMobEntity;
    @Nullable
    private LivingEntity owner;
    private final float speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public ClayMobFollowTeamOwner(ClayMobEntity clayMobEntity, float speedModifier, float startDistance, float stopDistance) {
        this.clayMobEntity = clayMobEntity;
        this.speedModifier = speedModifier;
        this.navigation = clayMobEntity.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(clayMobEntity.getNavigation() instanceof GroundPathNavigation) && !(clayMobEntity.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean canUse() {
        Player livingentity = this.clayMobEntity.getClayTeamOwner();
        if (livingentity == null) {
            return false;
        }
        if (this.clayMobEntity.unableToMoveToOwner()) {
            return false;
        }
        if (this.clayMobEntity.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return !this.clayMobEntity.unableToMoveToOwner() && !(this.clayMobEntity.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.clayMobEntity.getPathfindingMalus(PathType.WATER);
        this.clayMobEntity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.clayMobEntity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean shouldTryTeleportToOwner = this.clayMobEntity.shouldTryTeleportToOwner();
        if (!shouldTryTeleportToOwner) {
            this.clayMobEntity.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.clayMobEntity.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (shouldTryTeleportToOwner) {
                this.clayMobEntity.tryToTeleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, (double)this.speedModifier);
            }
        }
    }
}

