/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public abstract class ClaySoldierMeleeGoal
extends Goal {
    protected final AbstractClaySoldierEntity claySoldier;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 10L;
    private static final int COOLDOWN_BETWEEN_CAN_ATTACKS = 2;

    public ClaySoldierMeleeGoal(AbstractClaySoldierEntity claySoldier, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.claySoldier = claySoldier;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected abstract boolean canUsePredicate();

    public boolean canUse() {
        if (!this.canUsePredicate()) {
            return false;
        }
        long gameTime = this.claySoldier.level().getGameTime();
        if (gameTime - this.lastCanUseCheck < 10L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        LivingEntity target = this.claySoldier.getTarget();
        if (!(target instanceof ClayMobEntity) && !this.isTargetFromOwner(target)) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        this.path = this.claySoldier.getNavigation().createPath((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.claySoldier.isWithinMeleeAttackRange(target);
    }

    protected boolean isTargetFromOwner(LivingEntity target) {
        Player owner = this.claySoldier.getClayTeamOwner();
        if (owner != null && target != null) {
            return target.equals((Object)owner.getLastHurtMob()) || target.equals((Object)owner.getLastHurtByMob());
        }
        return false;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.claySoldier.getTarget();
        if (!(target instanceof ClayMobEntity) && !this.isTargetFromOwner(target)) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.claySoldier.getNavigation().isDone();
        }
        return this.claySoldier.isWithinRestriction(target.blockPosition());
    }

    public void start() {
        this.claySoldier.getNavigation().moveTo(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingentity = this.claySoldier.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.claySoldier.setTarget(null);
        }
        this.claySoldier.getNavigation().stop();
    }

    public void tick() {
        LivingEntity target = this.claySoldier.getTarget();
        if (target != null) {
            this.claySoldier.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.claySoldier.getSensing().hasLineOfSight((Entity)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.claySoldier.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = target.getX();
                this.pathedTargetY = target.getY();
                this.pathedTargetZ = target.getZ();
                this.ticksUntilNextPathRecalculation = 2;
                double distanceTarget = this.claySoldier.distanceToSqr((Entity)target);
                if (distanceTarget > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distanceTarget > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.claySoldier.getNavigation().moveTo((Entity)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformMeleeEffect(target);
        }
    }

    protected void checkAndPerformMeleeEffect(LivingEntity pTarget) {
        if (this.canPerformMeleeAction(pTarget)) {
            this.resetAttackCooldown();
            this.performMeleeAction(pTarget);
            this.claySoldier.indicateMeleeItemUse();
        }
    }

    protected abstract void performMeleeAction(LivingEntity var1);

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(2);
    }

    protected boolean isTimeToPerformMeleeAction() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformMeleeAction(LivingEntity target) {
        return this.isTimeToPerformMeleeAction() && this.claySoldier.isWithinMeleeAttackRange(target) && this.claySoldier.getSensing().hasLineOfSight((Entity)target);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

