/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierRangedAttackGoal
extends Goal {
    private static final int DEFAULT_ATTACK_TIME = 40;
    private final AbstractClaySoldierEntity mob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private int attackIntervalMin;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public ClaySoldierRangedAttackGoal(AbstractClaySoldierEntity pRangedAttackMob, double pSpeedModifier, float pAttackRadius) {
        this.mob = pRangedAttackMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = 40;
        this.attackRadius = pAttackRadius;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.mob.canPerformRangeAttack()) {
            return false;
        }
        LivingEntity livingentity = this.mob.getTarget();
        if (!(livingentity instanceof AbstractClaySoldierEntity)) {
            return false;
        }
        if (livingentity.isAlive()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target.isAlive() && !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double distanceToTarget = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean canSeeTarget = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = canSeeTarget ? ++this.seeTime : 0;
        if (!(distanceToTarget > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!canSeeTarget) {
                return;
            }
            float f = (float)Math.sqrt(distanceToTarget) / this.attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.mob.performRangedAttack(this.target, f1);
            this.attackTime = Mth.floor((float)(f * (float)this.attackIntervalMin));
            this.updateAttackInterval();
        } else if (this.attackTime < 0) {
            this.attackTime = this.attackIntervalMin;
        }
    }

    private void updateAttackInterval() {
        this.attackIntervalMin = this.mob.getAttackType().isSupportive() ? 220 : 40;
    }
}

