/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.SoldierSlotCallback;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UseAssignedPoiGoal
extends Goal {
    private static final int MAX_WAIT_BEFORE_NEXT_ATTEMPT = 200;
    private final ClayMobEntity clayMob;
    private final double speedModifier;
    private int waitTime = 0;

    public UseAssignedPoiGoal(ClayMobEntity clayMob, double pSpeedModifier) {
        this.clayMob = clayMob;
        this.speedModifier = pSpeedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.isPoiUsable();
    }

    public boolean canContinueToUse() {
        return this.clayMob.getPoiPos() != null && this.clayMob.getPoiCapability() != null;
    }

    private boolean isPoiUsable() {
        if (--this.waitTime > 0) {
            return false;
        }
        if (this.clayMob.getPoiPos() == null) {
            return false;
        }
        AssignablePoiCapability cap = this.clayMob.getPoiCapability();
        if (cap == null || !cap.canUse(this.clayMob)) {
            this.waitTime = 200;
            return false;
        }
        return true;
    }

    public void start() {
        this.moveToPoi();
        this.clayMob.setUsingPoi(true);
    }

    public void tick() {
        if (!this.moveToPoi()) {
            return;
        }
        AssignablePoiCapability cap = this.clayMob.getPoiCapability();
        if (cap != null && cap.canUse(this.clayMob)) {
            cap.use(this.clayMob);
            if (cap.isOneTimeUse()) {
                this.clayMob.setPoiPos(null);
            }
        } else {
            this.clayMob.setPoiPos(null);
        }
    }

    public void stop() {
        this.clayMob.setUsingPoi(false);
    }

    private boolean moveToPoi() {
        BlockPos pos = this.clayMob.getPoiPos();
        if (pos != null) {
            if (pos.closerToCenterThan((Position)this.clayMob.position(), 1.0)) {
                this.clayMob.getNavigation().stop();
                return true;
            }
            this.clayMob.getNavigation().moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, this.speedModifier);
            return false;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static IBlockCache<AssignablePoiCapability> createCache(ClayMobEntity clayMob, ServerLevel level) {
        IBlockCache<AssignablePoiCapability> cache = ClaySoldiersCommon.CAPABILITY_MANGER.createPoiCache(level, clayMob.getPoiPos());
        if (cache.getCapability() != null) {
            return cache;
        }
        IBlockCache<IBlockStorageAccess> storageCache = ClaySoldiersCommon.CAPABILITY_MANGER.create(level, clayMob.getPoiPos());
        if (storageCache.getCapability() != null) {
            return new StorageWrappedPoiCache(storageCache);
        }
        return cache;
    }

    private static int canEquipStack(AbstractClaySoldierEntity inventory, ItemStack stack, Set<SoldierEquipmentSlot> slots) {
        if (!inventory.canHoldItem(stack)) {
            return 0;
        }
        SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(stack);
        if (effect == null) {
            return 0;
        }
        boolean anySuitableSlot = false;
        for (SoldierEquipmentSlot suitableSlot : effect.slots()) {
            if (!slots.contains(suitableSlot)) continue;
            anySuitableSlot = true;
            break;
        }
        if (!anySuitableSlot) {
            return 0;
        }
        if (!inventory.couldEquipStack(effect)) {
            return 0;
        }
        return Math.min(effect.getMaxStackSize(), stack.getMaxStackSize());
    }

    private static void equipStack(AbstractClaySoldierEntity soldier, ItemStack stack, List<ItemStack> overflow, Set<SoldierEquipmentSlot> remainingSlots) {
        SlotCallBack slotHolder = new SlotCallBack();
        ItemStack equippedStack = soldier.equipItemIfPossible(stack, slotHolder);
        int remaining = stack.getCount() - equippedStack.getCount();
        if (remaining > 0) {
            overflow.add(equippedStack.copyWithCount(remaining));
        }
        if (slotHolder.slot != null) {
            remainingSlots.remove(slotHolder.slot);
        }
    }

    private record StorageWrappedPoiCache(IBlockCache<IBlockStorageAccess> cache) implements IBlockCache<AssignablePoiCapability>
    {
        @Override
        public BlockPos pos() {
            return this.cache.pos();
        }

        @Override
        @Nullable
        public AssignablePoiCapability getCapability() {
            return this.cache.getCapability() == null ? null : new StorageWrappedPoiCap(this.cache.getCapability());
        }
    }

    private static class SlotCallBack
    implements SoldierSlotCallback {
        private SoldierEquipmentSlot slot = null;

        private SlotCallBack() {
        }

        @Override
        public void slot(SoldierEquipmentSlot slot) {
            this.slot = slot;
        }

        @Override
        public void capability() {
        }

        @Override
        public void carried() {
        }
    }

    private record StorageWrappedPoiCap(IBlockStorageAccess storage) implements AssignablePoiCapability
    {
        @Override
        public boolean canUse(ClayMobEntity clayMob) {
            return clayMob instanceof AbstractClaySoldierEntity;
        }

        @Override
        public void use(ClayMobEntity clayMob) {
            if (!(clayMob instanceof AbstractClaySoldierEntity)) {
                return;
            }
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)clayMob;
            EnumSet<SoldierEquipmentSlot> emptySlots = EnumSet.noneOf(SoldierEquipmentSlot.class);
            for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
                if (!soldier.getItemBySlot(slot).isEmpty()) continue;
                emptySlots.add(slot);
            }
            ArrayList notNeededStacks = new ArrayList();
            this.storage.forEach(stack -> UseAssignedPoiGoal.canEquipStack(soldier, stack, emptySlots), stack -> UseAssignedPoiGoal.equipStack(soldier, stack, notNeededStacks, emptySlots), emptySlots::isEmpty);
            notNeededStacks.forEach(this.storage::tryInserting);
        }
    }
}

