/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.target;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class ClayMobOwnerTarget
extends TargetGoal {
    private final ClayMobEntity clayMob;
    private LivingEntity ownerLastHurt;
    private int timestamp;

    public ClayMobOwnerTarget(ClayMobEntity clayMob) {
        super((Mob)clayMob, false);
        this.clayMob = clayMob;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (!this.clayMob.isOrderedToSit()) {
            Player owner = this.clayMob.getClayTeamOwner();
            if (owner == null) {
                return false;
            }
            this.ownerLastHurt = owner.getLastHurtMob();
            int i = owner.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT) && this.clayMob.wantsToAttack(this.ownerLastHurt, (LivingEntity)owner);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurt);
        Player livingentity = this.clayMob.getClayTeamOwner();
        if (livingentity != null) {
            this.timestamp = livingentity.getLastHurtMobTimestamp();
        }
        super.start();
    }
}

