/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.IWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkGoal
extends Goal
implements IWorkGoal {
    public static final String BREAK_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "on_break");
    public static final String STUCK_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "stuck");
    public static final String SEARCHING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "searching_item");
    public static final String CARRYING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "carrying");
    public static final String REQUIRES_POI_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "requires_poi");
    public static final String RETURNING_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "returning");
    protected static final byte BREAK_ID = 0;
    protected static final byte SEARCHING_ID = 1;
    protected static final byte CARRYING_ID = 2;
    protected static final byte REQUIRES_POI_ID = 3;
    protected static final byte RETURNING_ID = 4;
    private static final int MAX_BREAK_TIME = 20;
    protected final AbstractClaySoldierEntity soldier;
    private final Supplier<WorkSelectorGoal> workSelector;
    private IBlockCache<IBlockStorageAccess> capCache;
    private int breakTime = 0;
    private byte status = 0;
    private final List<? extends Component> statuses;

    public AbstractWorkGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        this(soldier, workSelector, List.of(BREAK_LANG, SEARCHING_LANG, CARRYING_LANG, REQUIRES_POI_LANG, RETURNING_LANG));
    }

    protected AbstractWorkGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, List<String> statusesKey) {
        this.soldier = soldier;
        this.workSelector = workSelector;
        if (statusesKey.size() >= 7) {
            throw new IllegalArgumentException("Cannot have more than 7 Statuses per WorkGoal");
        }
        this.statuses = statusesKey.stream().map(Component::translatable).toList();
    }

    @Nullable
    protected BlockPos getPoiPos() {
        return this.workSelector.get().getSoldierPoiPos();
    }

    protected void setCapCache() {
        this.capCache = this.getPoiPos() != null ? ClaySoldiersCommon.CAPABILITY_MANGER.create((ServerLevel)this.soldier.level(), this.getPoiPos()) : null;
    }

    @Nullable
    protected IBlockCache<IBlockStorageAccess> getCapCache() {
        return this.capCache;
    }

    protected IBlockCache<IBlockStorageAccess> getCapCacheResetIfInvalid() {
        if (this.capCache == null) {
            this.setCapCache();
        } else if (!this.capCache.pos().equals((Object)this.getPoiPos())) {
            this.setCapCache();
        }
        return this.capCache;
    }

    protected boolean isOnBreak() {
        if (this.breakTime > 0) {
            --this.breakTime;
            return true;
        }
        return false;
    }

    protected boolean moveToPoi() {
        BlockPos pos = this.getPoiPos();
        if (pos != null) {
            if (pos.closerToCenterThan((Position)this.soldier.position(), 2.0)) {
                this.soldier.getNavigation().stop();
                return true;
            }
            this.soldier.getNavigation().moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1.2);
            return false;
        }
        return false;
    }

    public void setStatus(byte status) {
        this.status = status;
        this.workSelector.get().onWorkStatusChange();
    }

    protected void takeAShortBreak() {
        this.breakTime = 20;
        this.setStatus((byte)0);
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public Component decodeStatus(byte id) {
        if (this.statuses.size() <= id || id < 0) {
            return IWorkGoal.super.decodeStatus(id);
        }
        return this.statuses.get(id);
    }
}

