/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.goal.workgoal.IWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BreakCropGoal
extends MoveToBlockGoal
implements IWorkGoal {
    public static final String BREAK_CROPS_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "breaking_crops");
    public static final String CROP_BREAK_DISALLOWED = "clay_soldier_work.%s.job.%s".formatted("csr", "breaking_crops.disallowed");
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;
    private static final byte CANT_BREAK_BLOCK_STATUS = 1;
    private byte status = 0;
    private final Supplier<WorkSelectorGoal> workSelector;

    public BreakCropGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange, Supplier<WorkSelectorGoal> workSelector) {
        super(pMob, pSpeedModifier, pSearchRange, 2);
        this.workSelector = workSelector;
    }

    public boolean canUse() {
        if (!ClaySoldiersCommon.COMMON_HOOKS.canEntityGrief(this.mob.level(), (Entity)this.mob)) {
            if (this.status != 1) {
                this.status = 1;
                this.workSelector.get().onWorkStatusChange();
            }
            return false;
        }
        if (this.status != 0) {
            this.status = 0;
            this.workSelector.get().onWorkStatusChange();
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.findNearestBlock()) {
            this.nextStartTick = BreakCropGoal.reducedTickDelay((int)20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    public double acceptedDistance() {
        return 2.0;
    }

    protected int nextStartTick(PathfinderMob pCreature) {
        return BreakCropGoal.reducedTickDelay((int)(40 + pCreature.getRandom().nextInt(40)));
    }

    public void stop() {
        super.stop();
        this.mob.fallDistance = 1.0f;
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void tick() {
        super.tick();
        Level level = this.mob.level();
        BlockPos mobPos = this.mob.blockPosition();
        BlockPos cropPos = this.getPosWithBlock(mobPos, (BlockGetter)level);
        RandomSource randomsource = this.mob.getRandom();
        if (this.isReachedTarget() && cropPos != null) {
            Vec3 mobMovement;
            BlockState toDestroy = level.getBlockState(cropPos);
            if (this.ticksSinceReachedGoal > 0) {
                mobMovement = this.mob.getDeltaMovement();
                this.mob.setDeltaMovement(mobMovement.x, 0.3, mobMovement.z);
                if (!level.isClientSide) {
                    double particleOffset = 0.08;
                    ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, toDestroy), (double)cropPos.getX() + 0.5, (double)cropPos.getY() + 0.7, (double)cropPos.getZ() + 0.5, 1, ((double)randomsource.nextFloat() - 0.5) * particleOffset, ((double)randomsource.nextFloat() - 0.5) * particleOffset, ((double)randomsource.nextFloat() - 0.5) * particleOffset, (double)0.15f);
                }
            }
            if (this.ticksSinceReachedGoal % 2 == 0) {
                mobMovement = this.mob.getDeltaMovement();
                this.mob.setDeltaMovement(mobMovement.x, -0.3, mobMovement.z);
                if (this.ticksSinceReachedGoal % 6 == 0) {
                    this.playDestroyProgressSound((LevelAccessor)level, this.blockPos);
                }
            }
            if (this.ticksSinceReachedGoal > 20) {
                this.breakCrop(level, cropPos);
                if (!level.isClientSide) {
                    this.playBreakSound(level, cropPos);
                }
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    private void breakCrop(Level level, BlockPos pPos) {
        level.destroyBlock(pPos, true, (Entity)this.mob);
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    @Nullable
    private BlockPos getPosWithBlock(BlockPos center, BlockGetter pLevel) {
        BlockPos[] aroundAbove;
        BlockPos[] around;
        if (BreakCropGoal.blockPredicate(pLevel.getBlockState(center))) {
            return center;
        }
        for (BlockPos offsetPos : around = new BlockPos[]{center.below(), center.west(), center.east(), center.north(), center.south(), center.above()}) {
            if (!BreakCropGoal.blockPredicate(pLevel.getBlockState(offsetPos))) continue;
            return offsetPos;
        }
        for (BlockPos offsetPos : aroundAbove = new BlockPos[]{center.west().above(), center.east().above(), center.north().above(), center.south().above()}) {
            if (!BreakCropGoal.blockPredicate(pLevel.getBlockState(offsetPos))) continue;
            return offsetPos;
        }
        return null;
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.getChunk(SectionPos.blockToSectionCoord((int)pPos.getX()), SectionPos.blockToSectionCoord((int)pPos.getZ()), ChunkStatus.FULL, false);
        return chunkaccess != null && BreakCropGoal.blockPredicate(chunkaccess.getBlockState(pPos));
    }

    private static boolean blockPredicate(BlockState state) {
        CropBlock block;
        Block block2 = state.getBlock();
        return block2 instanceof CropBlock && (block = (CropBlock)block2).isMaxAge(state);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)BREAK_CROPS_LANG);
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public Component decodeStatus(byte id) {
        if (id == 1) {
            return Component.translatable((String)CROP_BREAK_DISALLOWED);
        }
        return IWorkGoal.super.decodeStatus(id);
    }
}

