/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.Optional;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class BuildBlueprintGoal
extends AbstractWorkGoal {
    public static final String BUILDING_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "building");
    @Nullable
    private IBlockCache<BlueprintRequestHandler> easelPos = null;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    @Nullable
    private BlueprintRequest request = null;
    private boolean bringBack = false;

    public BuildBlueprintGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, int searchRange) {
        super(soldier, workSelector);
        this.searchRange = searchRange;
        this.verticalSearchRange = 2;
    }

    public boolean canUse() {
        if (this.isOnBreak()) {
            return false;
        }
        return this.getPoiPos() != null && this.getCapCacheResetIfInvalid() != null;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse();
    }

    public void tick() {
        if (this.easelPos == null) {
            this.setStatus((byte)3);
            this.easelPos = this.findNearestBlock().map(this::getBlueprintCache).orElse(null);
            return;
        }
        if (this.request == null) {
            if (this.bringBack) {
                this.setStatus((byte)4);
                if (this.returnCarried()) {
                    this.bringBack = false;
                }
            } else {
                this.getRequestJob();
                this.setStatus((byte)1);
            }
        } else if (this.request.isCancelled() || this.request.isFinished()) {
            this.bringBack = !this.soldier.getCarriedStack().isEmpty();
            this.request = null;
        } else if (this.request.hasStarted()) {
            this.getRequestFromStorage();
        } else if (this.request.isPlacing()) {
            this.setStatus((byte)2);
            if (this.moveToRequest()) {
                this.placeBlock();
            }
        }
    }

    private void getRequestFromStorage() {
        if (this.moveToPoi()) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess storage = this.getCapCache().getCapability();
            if (storage != null) {
                if (!this.soldier.getCarriedStack().isEmpty()) {
                    ItemStack returned = storage.tryInserting(this.soldier.getCarriedStack());
                    this.soldier.dropItemStack(returned);
                }
                this.soldier.setCarriedStack(storage.tryExtracting(stack -> stack.is(this.request.getItem()), 1));
                this.request.setPlacing();
            } else {
                this.easelPos = null;
                this.request = null;
            }
        }
    }

    private boolean returnCarried() {
        if (this.moveToPoi()) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess storage = this.getCapCache().getCapability();
            if (storage != null) {
                this.soldier.spawnAtLocation(storage.tryInserting(this.soldier.getCarriedStack()));
                this.soldier.setCarriedStack(ItemStack.EMPTY);
            } else {
                this.soldier.dropCarried();
            }
            return true;
        }
        return false;
    }

    private void getRequestJob() {
        if (!this.moveMobToEasel()) {
            return;
        }
        BlueprintRequestHandler requestHandler = this.easelPos.getCapability();
        if (requestHandler != null) {
            this.request = requestHandler.getRequest(this::canReach);
        } else {
            this.easelPos = null;
        }
    }

    private boolean canReach(BlockPos pos) {
        Path path = this.soldier.getNavigation().createPath(pos, 2);
        return path != null && path.canReach();
    }

    private void placeBlock() {
        BlueprintRequestHandler requestHandler = this.easelPos.getCapability();
        if (requestHandler != null) {
            if (requestHandler.doRequest(this.request)) {
                this.soldier.setCarriedStack(ItemStack.EMPTY);
                this.request.setFinished();
            } else {
                this.bringBack = true;
                this.request.cancel();
            }
            this.request = null;
        } else {
            this.easelPos = null;
        }
    }

    protected Optional<BlockPos> findNearestBlock() {
        BlockPos center = this.soldier.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int searchIndex = this.verticalSearchStart;
        while (searchIndex <= this.verticalSearchRange) {
            for (int rangeIndex = 0; rangeIndex < this.searchRange; ++rangeIndex) {
                int i1 = 0;
                while (i1 <= rangeIndex) {
                    int j1;
                    int n = j1 = i1 < rangeIndex && i1 > -rangeIndex ? rangeIndex : 0;
                    while (j1 <= rangeIndex) {
                        blockpos$mutableblockpos.setWithOffset((Vec3i)center, i1, searchIndex - 1, j1);
                        if (this.soldier.isWithinRestriction((BlockPos)blockpos$mutableblockpos) && this.isValidTarget((LevelReader)this.soldier.level(), (BlockPos)blockpos$mutableblockpos)) {
                            return Optional.of(blockpos$mutableblockpos);
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            searchIndex = searchIndex > 0 ? -searchIndex : 1 - searchIndex;
        }
        return Optional.empty();
    }

    protected boolean moveMobToEasel() {
        if (this.easelPos == null) {
            return false;
        }
        if (this.easelPos.pos().closerToCenterThan((Position)this.soldier.position(), 2.0)) {
            this.soldier.getNavigation().stop();
            return true;
        }
        this.soldier.getNavigation().moveTo((double)this.easelPos.pos().getX() + 0.5, (double)(this.easelPos.pos().getY() + 1), (double)this.easelPos.pos().getZ() + 0.5, 1.0);
        return false;
    }

    protected boolean moveToRequest() {
        if (this.request.getPos().closerToCenterThan((Position)this.soldier.position(), 2.0)) {
            this.soldier.getNavigation().stop();
            return true;
        }
        this.soldier.getNavigation().moveTo((double)this.request.getPos().getX() + 0.5, (double)(this.request.getPos().getY() + 1), (double)this.request.getPos().getZ() + 0.5, 1.0);
        return false;
    }

    protected boolean isValidTarget(LevelReader pLevel, @Nullable BlockPos pPos) {
        return pPos != null && pLevel.getBlockState(pPos).is(ModBlocks.EASEL_BLOCK.get());
    }

    private IBlockCache<BlueprintRequestHandler> getBlueprintCache(BlockPos pos) {
        if (pos != null) {
            return ClaySoldiersCommon.CAPABILITY_MANGER.createBlueprint((ServerLevel)this.soldier.level(), pos);
        }
        return null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)BUILDING_LANG);
    }

    public void stop() {
        if (this.request != null) {
            this.request.cancel();
        }
    }

    @Override
    public String asString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.easelPos == null ? "Null" : "Cap";
        objectArray[1] = this.request;
        objectArray[2] = this.request == null ? (this.bringBack ? "bringBack" : "-") : (this.canReach(this.request.getPos()) ? "Can Reach" : "Cannot Reach");
        return "BuildBlueprintGoal{%s: %s(%s)}".formatted(objectArray);
    }
}

