/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.goal.workgoal.IWorkGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class WorkSelectorGoal
extends Goal
implements SoldierStatusHolder {
    public static final String WORK_STATUS_PAIR_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "work_pair");
    public static final String WORK_STATUS_SOMETHING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "something");
    public static final String WORK_STATUS_RESTING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "resting");
    private static final int MAX_INDEX_SIZE = 15;
    private static final String WORK_MODE_TAG = "WorkMode";
    public static final int RESTING_INDEX = -1;
    private final AbstractClaySoldierEntity soldier;
    private final Goal[] availableWorkGoals;
    private int workIndex = -1;
    @Nullable
    private Goal activeGoal;

    public WorkSelectorGoal(AbstractClaySoldierEntity soldier, List<Goal> goals) {
        this.soldier = soldier;
        if (goals.stream().anyMatch(goal -> !(goal instanceof IWorkGoal))) {
            ClaySoldiersCommon.LOGGER.warn("ClaySoldier has Work that does not extend {}", (Object)IWorkGoal.class.getSimpleName());
        }
        if (goals.size() > 15) {
            this.availableWorkGoals = goals.subList(0, 15).toArray(new Goal[0]);
            ErrorHandler.INSTANCE.error("Cannot have more than 15 available work goals");
        } else {
            this.availableWorkGoals = goals.toArray(new Goal[0]);
        }
    }

    public boolean isWorking() {
        return this.workIndex >= 0;
    }

    private void setWorkMode(int mode) {
        if (mode < this.availableWorkGoals.length) {
            this.workIndex = mode;
        }
        this.activeGoal = this.workIndex >= 0 ? this.availableWorkGoals[this.workIndex] : null;
    }

    public boolean workRequiresItemPickUp() {
        IWorkGoal iWorkGoal;
        Goal goal;
        return !this.soldier.isInSittingPose() && (goal = this.activeGoal) instanceof IWorkGoal && (iWorkGoal = (IWorkGoal)goal).workRequiresItemPickUp();
    }

    public boolean workRequiresItemCarrying() {
        IWorkGoal workGoal;
        Goal goal;
        return !this.soldier.isInSittingPose() && (goal = this.activeGoal) instanceof IWorkGoal && (workGoal = (IWorkGoal)goal).workRequiresItemCarrying();
    }

    public void cycleWorkMode() {
        this.workIndex = this.workIndex < this.availableWorkGoals.length - 1 ? ++this.workIndex : -1;
        this.resetGoal();
        this.setWorkMode(this.workIndex);
        this.onWorkStatusChange();
    }

    public Component getWorkDisplayName() {
        Goal goal = this.activeGoal;
        if (goal instanceof IWorkGoal) {
            IWorkGoal workGoal = (IWorkGoal)goal;
            return workGoal.getDisplayName();
        }
        if (this.workIndex == -1) {
            return Component.translatable((String)WORK_STATUS_RESTING_LANG);
        }
        return Component.translatable((String)WORK_STATUS_SOMETHING_LANG);
    }

    public boolean shouldStayAtWork() {
        return this.workIndex > -1 || this.getSoldierPoiPos() != null;
    }

    public boolean canUse() {
        return this.mayUse(Goal::canUse);
    }

    public boolean canContinueToUse() {
        return this.mayUse(Goal::canContinueToUse);
    }

    private boolean mayUse(Predicate<Goal> predicate) {
        if (this.soldier.isOrderedToSit()) {
            return false;
        }
        if (this.soldier.getClayTeamOwnerUUID() == null) {
            return false;
        }
        if (this.workIndex >= 0 && this.soldier.getAttackType().canWork() && this.checkGoal(predicate)) {
            return true;
        }
        this.moveToPoi(this.getSoldierPoiPos());
        return false;
    }

    private void moveToPoi(BlockPos poi) {
        if (poi != null && !poi.closerToCenterThan((Position)this.soldier.position(), 12.0)) {
            this.soldier.getNavigation().moveTo((double)poi.getX() + 0.5, (double)poi.getY(), (double)poi.getZ() + 0.5, 1.0);
        }
    }

    public void start() {
        this.doGoalEffect(Goal::start);
    }

    public void stop() {
        this.doGoalEffect(Goal::stop);
    }

    public boolean requiresUpdateEveryTick() {
        return this.checkGoal(Goal::requiresUpdateEveryTick);
    }

    public void tick() {
        this.doGoalEffect(Goal::tick);
    }

    private void doGoalEffect(Consumer<Goal> action) {
        if (this.activeGoal != null) {
            action.accept(this.activeGoal);
        }
    }

    private boolean checkGoal(Predicate<Goal> predicate) {
        return this.activeGoal != null && predicate.test(this.activeGoal);
    }

    @Nullable
    protected BlockPos getSoldierPoiPos() {
        return this.soldier.getPoiPos();
    }

    protected void onWorkStatusChange() {
        byte by;
        Goal goal = this.activeGoal;
        if (goal instanceof IWorkGoal) {
            IWorkGoal goal2 = (IWorkGoal)goal;
            by = goal2.getStatus();
        } else {
            by = 0;
        }
        byte goalStatus = by;
        this.soldier.setDataWorkStatus(WorkSelectorGoal.encodeWorkStatusToByte(this.workIndex, goalStatus));
    }

    public static byte encodeWorkStatusToByte(int workIndex, int status) {
        return (byte)(workIndex << 3 | status & 7);
    }

    @Nullable
    private Component decodeWorkStatus(byte data) {
        int rebuiltWorkIndex = data >> 3 & 0x1F;
        rebuiltWorkIndex = rebuiltWorkIndex << 27 >> 27;
        byte goalStatus = (byte)(data & 7);
        if (rebuiltWorkIndex <= -1) {
            return null;
        }
        Goal goal = this.availableWorkGoals[rebuiltWorkIndex];
        if (goal instanceof IWorkGoal) {
            IWorkGoal workGoal = (IWorkGoal)goal;
            return Component.translatable((String)WORK_STATUS_PAIR_LANG, (Object[])new Object[]{workGoal.getDisplayName(), workGoal.decodeStatus(goalStatus)});
        }
        return Component.translatable((String)IWorkGoal.DEFAULT_STATUS_LANG);
    }

    @Override
    @Nullable
    public Component getStatusDisplayName() {
        return this.soldier.getAttackType().canWork() ? this.decodeWorkStatus(this.soldier.getDataWorkStatus()) : null;
    }

    public void saveToTag(CompoundTag tag) {
        tag.putByte(WORK_MODE_TAG, (byte)this.workIndex);
    }

    public void readFromTag(CompoundTag tag) {
        this.setWorkMode(tag.getByte(WORK_MODE_TAG));
        this.onWorkStatusChange();
    }

    public void resetGoal() {
        if (this.activeGoal != null) {
            this.activeGoal.stop();
        }
    }

    public String toString() {
        String string;
        Object[] objectArray = new Object[3];
        objectArray[0] = this.workIndex;
        objectArray[1] = this.availableWorkGoals.length - 1;
        if (this.activeGoal == null) {
            string = "Null";
        } else {
            Goal goal = this.activeGoal;
            if (goal instanceof IWorkGoal) {
                IWorkGoal workGoal = (IWorkGoal)goal;
                string = workGoal.asString();
            } else {
                string = this.activeGoal.getClass().getSimpleName();
            }
        }
        objectArray[2] = string;
        return "WorkSelectorGoal{%s/%s [%s]}".formatted(objectArray);
    }
}

