/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal.dig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DigBreakManger {
    private static final DigBreakManger INSTANCE = new DigBreakManger();
    private final Map<ResourceKey<Level>, Map<BlockPos, BreakData>> breakPosStateMap = new HashMap<ResourceKey<Level>, Map<BlockPos, BreakData>>();

    private DigBreakManger() {
    }

    public static DigBreakManger get() {
        return INSTANCE;
    }

    public void registerPos(BlockPos pos, Entity entity) {
        BreakData breakData = this.getBreakData(entity.level(), pos);
        if (breakData == null) {
            this.putBreakData(entity, pos, new BreakData(entity));
        } else {
            breakData.addEntity(entity);
        }
    }

    @Nullable
    private BreakData getBreakData(Level level, BlockPos pos) {
        Map<BlockPos, BreakData> map = this.breakPosStateMap.get(level.dimension());
        if (map != null) {
            return map.get(pos);
        }
        return null;
    }

    private void putBreakData(Entity entity, BlockPos pos, BreakData data) {
        Map map = this.breakPosStateMap.computeIfAbsent((ResourceKey<Level>)entity.level().dimension(), k -> new HashMap());
        map.put(pos, data);
    }

    private void removeBreakData(Level level, BlockPos pos) {
        Map map = this.breakPosStateMap.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new HashMap());
        map.remove(pos);
    }

    public void unregisterPos(BlockPos pos, Entity entity) {
        BreakData breakData = this.getBreakData(entity.level(), pos);
        if (breakData != null) {
            breakData.removeEntity(entity);
            if (breakData.isEmpty()) {
                this.removeBreakData(entity.level(), pos);
                entity.level().destroyBlockProgress(entity.getId(), pos, -1);
            }
        } else {
            ErrorHandler.INSTANCE.debug("Trying to unregister an Entity for a Empty BreakData");
        }
    }

    public int increaseBreakProgress(BlockPos pos, Level level) {
        BreakData breakData = this.getBreakData(level, pos);
        if (breakData == null) {
            ErrorHandler.INSTANCE.error("Trying to break a block with non existing break data");
            return -2;
        }
        BlockState state = level.getBlockState(pos);
        float destroySpeed = state.getDestroySpeed((BlockGetter)level, pos);
        int soldierNeeded = DigBreakManger.getSoldierNeededForState(state);
        if (soldierNeeded > breakData.size()) {
            return soldierNeeded;
        }
        if ((float)breakData.progress >= destroySpeed * 10.0f * 2.0f * (float)soldierNeeded) {
            this.removeBreakData(level, pos);
            level.destroyBlockProgress(breakData.getAny(), pos, -1);
            return -1;
        }
        int currentBreakProgress = (int)((float)breakData.progress / (destroySpeed * 2.0f * (float)soldierNeeded));
        if (breakData.lastBreakProgress != currentBreakProgress) {
            level.destroyBlockProgress(breakData.anyEntity, pos, currentBreakProgress);
            breakData.lastBreakProgress = currentBreakProgress;
        }
        ++breakData.progress;
        return 0;
    }

    private static int getSoldierNeededForState(BlockState state) {
        if (state.is(BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) {
            return 64;
        }
        if (state.is(BlockTags.INCORRECT_FOR_DIAMOND_TOOL)) {
            return 16;
        }
        if (state.is(BlockTags.INCORRECT_FOR_IRON_TOOL)) {
            return 8;
        }
        if (state.is(BlockTags.INCORRECT_FOR_GOLD_TOOL)) {
            return 4;
        }
        if (state.is(BlockTags.INCORRECT_FOR_STONE_TOOL)) {
            return 4;
        }
        if (state.is(BlockTags.INCORRECT_FOR_WOODEN_TOOL)) {
            return 2;
        }
        return 1;
    }

    public String toString() {
        return "DigBreakManger: " + this.breakPosStateMap.size() + String.valueOf(this.breakPosStateMap.values());
    }

    private static class BreakData {
        private final Set<Entity> working = new HashSet<Entity>();
        private int progress = 0;
        private int lastBreakProgress = -1;
        private int anyEntity;

        public BreakData(Entity entity) {
            this.working.add(entity);
            this.anyEntity = entity.getId();
        }

        public int getAny() {
            return this.anyEntity;
        }

        public void addEntity(Entity entity) {
            this.working.add(entity);
        }

        public void removeEntity(Entity entity) {
            if (!this.working.remove(entity)) {
                ErrorHandler.INSTANCE.debug("Tried removing non existing entity from BreakData");
            }
            if (this.anyEntity == entity.getId() && !this.working.isEmpty()) {
                this.anyEntity = this.working.iterator().next().getId();
            }
        }

        public int size() {
            return this.working.size();
        }

        public boolean isEmpty() {
            return this.working.isEmpty();
        }

        public String toString() {
            return "BD:" + this.working.size();
        }
    }
}

