/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal.dig;

import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigBreakManger;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.StairPosMap;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DigHoleGoal
extends AbstractWorkGoal {
    public static final String DIG_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "dig");
    public static final String BREAKING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "dig.breaking");
    public static final String UNBREAKABLE_BLOCK = "clay_soldier_work.%s.status.%s".formatted("csr", "dig.unbreakable_block");
    private static final byte BREAKING_ID = 2;
    private static final byte UNBREAKABLE_ID = 4;
    private final Level level;
    @Nullable
    private BlockPos currentPos;
    @Nullable
    private BlockPos lastPoiPos;
    @Nullable
    private StairPosMap stairPosMap;
    private final DigBreakManger digBreakManger;

    public DigHoleGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        super(soldier, workSelector, List.of(BREAK_LANG, SEARCHING_LANG, BREAKING_LANG, REQUIRES_POI_LANG, UNBREAKABLE_BLOCK));
        this.level = soldier.level();
        this.digBreakManger = !this.level.isClientSide ? DigBreakManger.get() : null;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)DIG_LANG);
    }

    public void tick() {
        if (this.lastPoiPos == null) {
            this.lastPoiPos = this.getPoiPos();
            return;
        }
        if (this.stairPosMap == null || this.currentPos == null) {
            this.setDigging();
            return;
        }
        if (!this.lastPoiPos.equals((Object)this.getPoiPos())) {
            this.resetBreakProgress();
            this.setDigging();
            return;
        }
        boolean requiresStair = this.stairPosMap.requiresStair(this.currentPos);
        if (this.isBlockConsideredBroken(this.currentPos, requiresStair)) {
            BlockPos.MutableBlockPos mut;
            BlockPos blockPos = this.currentPos;
            this.currentPos = this.getNextPos(blockPos instanceof BlockPos.MutableBlockPos ? (mut = (BlockPos.MutableBlockPos)blockPos) : this.currentPos.mutable());
            return;
        }
        if (this.moveToCurrentPos()) {
            if (requiresStair && this.level.getBlockState(this.currentPos).isAir()) {
                this.stairPosMap.placeStair(this.currentPos, this.level);
            } else {
                this.breakBlock(this.currentPos);
            }
        } else {
            this.setStatus((byte)1);
        }
    }

    private BlockPos getNextPos(BlockPos.MutableBlockPos current) {
        int xStart = this.lastPoiPos.getX() - 2;
        int zStart = this.lastPoiPos.getZ() - 2;
        int nextIndex = (current.getX() - xStart) * 5 + (current.getZ() - zStart);
        if (++nextIndex >= 25) {
            return this.lastPoiPos.offset(-2, current.getY() - this.lastPoiPos.getY() - 1, -2);
        }
        if (nextIndex <= 0) {
            ErrorHandler.INSTANCE.hide("Something went wrong while trying to find the next block to break");
        }
        int xRelative = nextIndex / 5;
        int zRelative = nextIndex % 5;
        current.set(xRelative + xStart, current.getY(), zRelative + zStart);
        return current;
    }

    public boolean canUse() {
        if (this.getPoiPos() == null) {
            this.setStatus((byte)3);
            return false;
        }
        this.setStatus((byte)1);
        return true;
    }

    public boolean canContinueToUse() {
        if (this.lastPoiPos == null) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void start() {
        this.setDigging();
    }

    public void stop() {
        this.resetBreakProgress();
    }

    private void breakBlock(BlockPos pos) {
        this.digBreakManger.registerPos(pos, (Entity)this.soldier);
        switch (this.digBreakManger.increaseBreakProgress(pos, this.level)) {
            case -2: {
                this.lastPoiPos = null;
            }
            case -1: {
                this.level.destroyBlock(pos, true, (Entity)this.soldier);
            }
            case 0: {
                this.setStatus((byte)2);
            }
        }
        this.setStatus((byte)4);
    }

    private boolean isBlockConsideredBroken(BlockPos pos, boolean stair) {
        BlockState state = this.level.getBlockState(pos);
        if (state.getDestroySpeed((BlockGetter)this.level, pos) < 0.0f) {
            return true;
        }
        if (stair) {
            return state.is(Blocks.COBBLESTONE_SLAB) || state.is(Blocks.COBBLESTONE_STAIRS);
        }
        return state.isAir();
    }

    private void setDigging() {
        this.lastPoiPos = this.getPoiPos();
        if (this.lastPoiPos != null) {
            this.currentPos = this.lastPoiPos.offset(-2, 0, -2).mutable();
            this.stairPosMap = new StairPosMap(this.lastPoiPos);
        } else {
            ErrorHandler.INSTANCE.hide("Tried to start digging but has not poi");
        }
    }

    private void resetBreakProgress() {
        if (this.currentPos != null) {
            this.digBreakManger.unregisterPos(this.currentPos, (Entity)this.soldier);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private boolean moveToCurrentPos() {
        if (this.currentPos != null) {
            if (this.currentPos.closerToCenterThan((Position)this.soldier.position(), 2.0)) {
                this.soldier.getNavigation().stop();
                return true;
            }
            this.soldier.getNavigation().moveTo((double)this.currentPos.getX() + 0.5, (double)(this.currentPos.getY() + 1), (double)this.currentPos.getZ() + 0.5, 1.0);
            return false;
        }
        return false;
    }
}

