/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import com.google.common.collect.Iterables;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.CustomEquipCapability;
import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.SoldierSlotCallback;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.ClaySoldierRideableMap;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.goal.ClayMobFollowTeamOwner;
import net.bumblebee.claysoldiers.entity.goal.ClayMobSitGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySodlierBreathAirGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeSupportGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMountGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierRangedAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.UseAssignedPoiGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClayMobOwnerHurtByTarget;
import net.bumblebee.claysoldiers.entity.goal.target.ClayMobOwnerTarget;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierHurtByTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierNearestTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.target.NearestRideableTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.BreakCropGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.BuildBlueprintGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.PickUpItemsGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.PlaceSeedsGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigHoleGoal;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierMoveControl;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusManager;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierThrowableItemEntity;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackEffectHolder;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierMenu;
import net.bumblebee.claysoldiers.networking.ClaySoldierReviveCooldownPayload;
import net.bumblebee.claysoldiers.networking.SoldierCarriedChangePayload;
import net.bumblebee.claysoldiers.networking.SoldierItemChangePayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClaySoldierSpawnPayload;
import net.bumblebee.claysoldiers.soldierpoi.FindNearestPoiGoal;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierHoldablePropertiesCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.WraithProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveResult;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.bumblebee.claysoldiers.util.color.EntityDataColorWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AbstractClaySoldierEntity
extends ClayMobTeamOwnerEntity
implements RangedAttackMob,
ClaySoldierInventoryHandler,
ClaySoldierLike {
    public static final String DEFENDING_AREA_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "defending_area");
    public static final String PROTECTING_OWNER_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "protecting_owner");
    public static final String BACKPACK_ITEMS_TAG = "SoldierBackpackItems";
    public static final String HAND_ITEMS_TAG = "SoldierHandItems";
    public static final String ARMOR_ITEMS_TAG = "SoldierArmorItems";
    public static final String OFFSET_COLOR_TAG = "OffsetColor";
    public static final String REVIVE_TYPE_COOLDOWN_TAG = "revive_type_cooldown";
    public static final String SKIN_VARIANT_ID_TAG = "SkinVariantId";
    public static final String CARRIED_ITEM_TAG = "CarriedItem";
    public static final String FUSE_TAG = "Fuse";
    public static final String EXPLOSION_RADIUS_TAG = "ExplosionRadius";
    public static final String IGNITED_TAG = "ignited";
    private static final EntityDataAccessor<Byte> DATA_WORK_STATUS = SynchedEntityData.defineId(AbstractClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.defineId(AbstractClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.defineId(AbstractClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Integer> DATA_OFFSET_COLOR = SynchedEntityData.defineId(AbstractClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_JEB = SynchedEntityData.defineId(AbstractClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final byte EXPLODE_FIREWORK_EVENT = 81;
    private static final int MIN_POWER_FOR_SPECIAL_ATTACKS = 1;
    protected final AttackTypeProperty defaultAttackType;
    private static final byte NO_GLIDE = -1;
    private static final byte GLIDE_UNCHECKED = -2;
    private byte lastGliderSlot = (byte)-2;
    private final NonNullList<ItemStackWithEffect> soldierHandItems = NonNullList.withSize((int)2, (Object)ItemStackWithEffect.EMPTY);
    private final NonNullList<ItemStackWithEffect> soldierArmorItems = NonNullList.withSize((int)5, (Object)ItemStackWithEffect.EMPTY);
    private final NonNullList<ItemStackWithEffect> soldierBackpackItems = NonNullList.withSize((int)2, (Object)ItemStackWithEffect.EMPTY);
    protected final SoldierHoldablePropertiesCombiner propertyCombiner;
    public float oBob;
    public float bob;
    private static final double MAGIC_CAPE_NUMBER = 10.0;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private float delayedScale;
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private float explosionRadius = 1.0f;
    @Nullable
    private ItemStackWithEffect stackWithProjectile;
    private int skinVariantId;
    private WorkSelectorGoal workSelector;
    private ItemStack carriedStack = ItemStack.EMPTY;
    private final SoldierStatusHolder statusManger;
    private final EntityDataColorWrapper colorGetter;
    private final Map<ReviveType, Long> reviveTypeCooldown = new EnumMap<ReviveType, Long>(ReviveType.class);
    private final PathNavigation waterNavigation;
    private final PathNavigation groundNavigation;
    private boolean inCombat = false;

    protected AbstractClaySoldierEntity(EntityType<? extends AbstractClaySoldierEntity> pEntityType, Level pLevel, AttackTypeProperty defaultAttackType) {
        this(pEntityType, pLevel, defaultAttackType, s -> SoldierStatusManager.initDefault(s, () -> s.workSelector));
        this.setCanPickUpLoot(true);
        this.setSpawnedFrom(ModItems.CLAY_SOLDIER.get().getDefaultInstance(), true);
        this.inWallDamage = (w, e) -> {
            if (this.workSelector.isWorking()) {
                return 0.2f;
            }
            return w ? 0.5f : 1.0f;
        };
        this.delayedScale = this.getSoldierSize();
    }

    protected AbstractClaySoldierEntity(EntityType<? extends AbstractClaySoldierEntity> pEntityType, Level pLevel, AttackTypeProperty defaultAttackType, Function<AbstractClaySoldierEntity, SoldierStatusHolder> statusManger) {
        super(pEntityType, pLevel);
        this.defaultAttackType = defaultAttackType;
        this.stackWithProjectile = null;
        this.propertyCombiner = new SoldierHoldablePropertiesCombiner(this, this.getAttributes());
        this.skinVariantId = this.getRandom().nextInt(2) == 1 ? 1 : 0;
        this.statusManger = statusManger.apply(this);
        this.colorGetter = new EntityDataColorWrapper(DATA_OFFSET_COLOR, DATA_IS_JEB, () -> ((AbstractClaySoldierEntity)this).getEntityData());
        this.waterNavigation = new AmphibiousPathNavigation((Mob)this, pLevel);
        this.groundNavigation = this.createNavigation(pLevel);
        this.moveControl = new ClaySoldierMoveControl(this, this::canSwim, 85, 10, false);
        this.workSelector = this.getOrCreateWorkSelectorGoal();
    }

    public static AttributeSupplier setSoldierAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 2.5).add(Attributes.ATTACK_SPEED, 0.1).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).build();
    }

    private static Iterable<ItemStack> convertToStack(List<ItemStackWithEffect> stackWithEffects) {
        return stackWithEffects.stream().map(ItemStackEffectHolder::stack).toList();
    }

    protected WorkSelectorGoal getOrCreateWorkSelectorGoal() {
        if (this.workSelector != null) {
            return this.workSelector;
        }
        ArrayList<Goal> goals = new ArrayList<Goal>(List.of(new BreakCropGoal(this, 1.0, 16, () -> this.workSelector), new PickUpItemsGoal(this, () -> this.workSelector), new PlaceSeedsGoal(this, () -> this.workSelector, 16), new DigHoleGoal(this, () -> this.workSelector)));
        if (ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(this.level().enabledFeatures())) {
            goals.add(new BuildBlueprintGoal(this, () -> this.workSelector, 8));
        }
        this.workSelector = new WorkSelectorGoal(this, goals);
        return this.workSelector;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ClaySodlierBreathAirGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ClayMobSitGoal(this));
        this.goalSelector.addGoal(3, (Goal)this.getOrCreateWorkSelectorGoal());
        this.goalSelector.addGoal(4, (Goal)new UseAssignedPoiGoal(this, 1.2));
        this.goalSelector.addGoal(4, (Goal)new FindNearestPoiGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ClaySoldierMountGoal(this, 1.2f, false));
        this.goalSelector.addGoal(5, (Goal)new ClaySoldierRangedAttackGoal(this, 1.25, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new ClaySoldierMeleeAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new ClaySoldierMeleeSupportGoal(this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new ClayMobFollowTeamOwner(this, 1.0f, 5.5f, 3.0f));
        this.goalSelector.addGoal(8, (Goal)new TemptGoal((PathfinderMob)this, (double)1.2f, x$0 -> this.isClayFood((ItemStack)x$0), false));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new ClaySoldierHurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestRideableTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new ClayMobOwnerHurtByTarget(this));
        this.targetSelector.addGoal(3, (Goal)new ClayMobOwnerTarget(this));
        this.targetSelector.addGoal(4, (Goal)new ClaySoldierNearestTargetGoal(this, false, this::targetPredicate, this::specificTargetPredicate));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addArmorSaveData(pCompound);
        pCompound.putShort(FUSE_TAG, (short)this.maxSwell);
        pCompound.putByte(EXPLOSION_RADIUS_TAG, (byte)this.explosionRadius);
        pCompound.putBoolean(IGNITED_TAG, this.isIgnited());
        this.getOffsetColor().writeToTag(OFFSET_COLOR_TAG, pCompound);
        CompoundTag reviveCooldownMapNBT = new CompoundTag();
        for (Map.Entry<ReviveType, Long> entry : this.reviveTypeCooldown.entrySet()) {
            Long value = entry.getValue();
            if (value == null) continue;
            reviveCooldownMapNBT.putLong(entry.getKey().getSerializedName(), value.longValue());
        }
        if (!reviveCooldownMapNBT.isEmpty()) {
            pCompound.put(REVIVE_TYPE_COOLDOWN_TAG, (Tag)reviveCooldownMapNBT);
        }
        pCompound.putInt(SKIN_VARIANT_ID_TAG, this.skinVariantId);
        this.workSelector.saveToTag(pCompound);
        this.workSelector.resetGoal();
        if (!this.carriedStack.isEmpty()) {
            pCompound.put(CARRIED_ITEM_TAG, this.carriedStack.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected void addArmorSaveData(CompoundTag tag) {
        tag.put(HAND_ITEMS_TAG, (Tag)this.createItemListTag((List<ItemStackWithEffect>)this.soldierHandItems));
        tag.put(ARMOR_ITEMS_TAG, (Tag)this.createItemListTag((List<ItemStackWithEffect>)this.soldierArmorItems));
        tag.put(BACKPACK_ITEMS_TAG, (Tag)this.createItemListTag((List<ItemStackWithEffect>)this.soldierBackpackItems));
    }

    private ListTag createItemListTag(List<ItemStackWithEffect> itemStacks) {
        ListTag listTag = new ListTag();
        for (ItemStackWithEffect stackWithEffect : itemStacks) {
            if (!stackWithEffect.isEmpty()) {
                listTag.add((Object)stackWithEffect.save((HolderLookup.Provider)this.registryAccess()));
                continue;
            }
            listTag.add((Object)new CompoundTag());
        }
        return listTag;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readArmorSaveData(pCompound);
        if (pCompound.contains(FUSE_TAG, 99)) {
            this.maxSwell = pCompound.getShort(FUSE_TAG);
        }
        if (pCompound.contains(EXPLOSION_RADIUS_TAG, 99)) {
            this.explosionRadius = pCompound.getByte(EXPLOSION_RADIUS_TAG);
        }
        if (pCompound.getBoolean(IGNITED_TAG)) {
            this.ignite();
        }
        this.setOffsetColor(ColorHelper.getFromTag(OFFSET_COLOR_TAG, pCompound));
        this.querySpecialProperties();
        this.initCombinedProperties();
        this.updateOtherProperties();
        if (pCompound.contains(REVIVE_TYPE_COOLDOWN_TAG, 10)) {
            CompoundTag reviveTypeNbt = pCompound.getCompound(REVIVE_TYPE_COOLDOWN_TAG);
            for (String key : reviveTypeNbt.getAllKeys()) {
                ReviveType.getFromString(key).ifPresent(type -> this.reviveTypeCooldown.put((ReviveType)type, reviveTypeNbt.getLong(key)));
            }
        }
        this.skinVariantId = pCompound.getInt(SKIN_VARIANT_ID_TAG);
        this.workSelector.readFromTag(pCompound);
        if (pCompound.contains(CARRIED_ITEM_TAG)) {
            this.carriedStack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)pCompound.getCompound(CARRIED_ITEM_TAG));
        }
    }

    protected void readArmorSaveData(CompoundTag tag) {
        AbstractClaySoldierEntity.getFromTag(tag, HAND_ITEMS_TAG, (arg_0, arg_1) -> this.soldierHandItems.set(arg_0, arg_1), this.registryAccess());
        AbstractClaySoldierEntity.getFromTag(tag, ARMOR_ITEMS_TAG, (arg_0, arg_1) -> this.soldierArmorItems.set(arg_0, arg_1), this.registryAccess());
        AbstractClaySoldierEntity.getFromTag(tag, BACKPACK_ITEMS_TAG, (arg_0, arg_1) -> this.soldierBackpackItems.set(arg_0, arg_1), this.registryAccess());
    }

    public static void getFromTag(CompoundTag tag, String key, BiConsumer<Integer, ItemStackWithEffect> listSetter, RegistryAccess registryAccess) {
        if (tag.contains(key, 9)) {
            ListTag listTag = tag.getList(key, 10);
            for (int index = 0; index < listTag.size(); ++index) {
                listSetter.accept(index, ItemStackWithEffect.parseOptional((HolderLookup.Provider)registryAccess, listTag.getCompound(index)));
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SWELL_DIR, (Object)-1);
        builder.define(DATA_IS_IGNITED, (Object)false);
        builder.define(DATA_WORK_STATUS, (Object)WorkSelectorGoal.encodeWorkStatusToByte(-1, 0));
        EntityDataColorWrapper.define(builder, DATA_OFFSET_COLOR, DATA_IS_JEB);
    }

    @Override
    protected void handleTeamChange(ResourceLocation teamId) {
        this.propertyCombiner.addPropertyFromTeam(ClayMobTeamManger.getFromKeyAssumeValid(teamId, this.registryAccess()));
        this.propertyCombiner.combine();
    }

    protected float getAttackPower(Entity target) {
        return target instanceof ClayMobEntity ? 1.0f : 0.2f;
    }

    public boolean doHurtTarget(Entity target) {
        List<SpecialAttack<?>> specialAttacks;
        boolean wasHurt;
        float power = this.getAttackPower(target);
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        float attackDamage = this.getBaseAttackDamage();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            attackDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getItemBySlot(SoldierEquipmentSlot.MAINHAND).stack(), (Entity)target, (DamageSource)damagesource, (float)attackDamage);
            attackDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getItemBySlot(SoldierEquipmentSlot.OFFHAND).stack(), (Entity)target, (DamageSource)damagesource, (float)attackDamage);
        }
        float knockBack = this.getKnockback(target, damagesource) * power;
        int secOnFireInTicks = 0;
        attackDamage += this.allProperties().damage();
        if ((secOnFireInTicks += this.allProperties().setOnFire()) > 0) {
            target.igniteForTicks((int)((float)secOnFireInTicks * power));
        }
        if (wasHurt = target.hurt(damagesource, (attackDamage += (float)(specialAttacks = this.allProperties().specialAttacks(SpecialAttackType.MELEE, SpecialEffectCategory.HARMFUL)).stream().mapToDouble(specialAttackType -> specialAttackType.getBonusDamage(this, target)).sum()) * power)) {
            Level level2;
            if (knockBack > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).knockback((double)(knockBack * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)target, (DamageSource)damagesource);
            }
            this.setLastHurtMob(target);
            this.playAttackSound();
            if (power >= 1.0f) {
                for (SpecialAttack specialAttack : specialAttacks) {
                    specialAttack.performAttackEffect(this, target);
                }
                this.specializedAttack(target);
            }
            if (target instanceof AbstractClaySoldierEntity) {
                AbstractClaySoldierEntity soldierTarget = (AbstractClaySoldierEntity)target;
                soldierTarget.performCounterAttacks(this, SpecialAttackType.MELEE);
            }
        }
        return wasHurt;
    }

    protected void specializedAttack(Entity target) {
    }

    protected float getBaseAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    private void performCounterAttacks(AbstractClaySoldierEntity target, SpecialAttackType type) {
        float sumDamage = 0.0f;
        for (SpecialAttack<?> counterAttack : this.allProperties().counterAttacks(type)) {
            counterAttack.performAttackEffect(this, (Entity)target);
            sumDamage += counterAttack.getBonusDamage(this, (Entity)target);
        }
        if (sumDamage > 0.0f) {
            target.hurt(this.damageSources().thorns((Entity)this), sumDamage);
        }
    }

    @Override
    protected InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.getItemInHand(pHand);
        if (this.getAttackType().isRoyalty() && this.isClayFood(itemInHand) && !pPlayer.equals((Object)this.getClayTeamOwner())) {
            if (!this.level().isClientSide) {
                if (this.tryClaimingTeam(pPlayer)) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)80);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)79);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    @Override
    protected boolean clayBrushEffect(ClayBrushItem.Mode mode, ItemStack itemInHand, Player player) {
        if (super.clayBrushEffect(mode, itemInHand, player)) {
            return true;
        }
        if (mode == ClayBrushItem.Mode.WORK && !this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.getAttackType().canWork()) {
                this.workSelector.cycleWorkMode();
                serverPlayer.sendSystemMessage(this.workSelector.getWorkDisplayName(), true);
            } else {
                serverPlayer.sendSystemMessage(this.getCombatDisplayName(), true);
            }
        }
        return true;
    }

    public boolean canHoldItem(ItemStack pStack) {
        if (!this.level().isClientSide && this.workSelector.workRequiresItemPickUp()) {
            return true;
        }
        return pStack.is(ModTags.Items.SOLDIER_HOLDABLE);
    }

    public boolean wantsToPickUp(ItemStack pStack) {
        return this.canHoldItem(pStack);
    }

    @NotNull
    public ItemStack equipItemIfPossible(ItemStack pStack) {
        return this.equipItemIfPossible(pStack, SoldierSlotCallback.NULL);
    }

    public ItemStack equipItemIfPossible(ItemStack stack, SoldierSlotCallback slotCallBack) {
        ItemStack equipped = this.equipSoldierItem(stack, slotCallBack);
        if (equipped.isEmpty()) {
            return this.equipGoalItem(stack, slotCallBack);
        }
        return equipped;
    }

    private ItemStack equipSoldierItem(ItemStack pStack, SoldierSlotCallback slotCallBack) {
        SoldierEquipmentSlot slot;
        ItemStackWithEffect newItem = new ItemStackWithEffect(pStack);
        SoldierHoldableEffect effect = newItem.effect();
        if (effect == null) {
            return ItemStack.EMPTY;
        }
        if (!this.couldEquipStack(effect)) {
            return ItemStack.EMPTY;
        }
        List<SoldierEquipmentSlot> possibleSlots = effect.slots();
        if (possibleSlots.isEmpty()) {
            CustomEquipCapability capEquip = effect.getCustomEquipCapability(pStack);
            ItemStack resultStack = capEquip != null ? capEquip.equip(this) : ItemStack.EMPTY;
            slotCallBack.capability();
            return resultStack;
        }
        ItemStackEffectHolder currentItem = null;
        boolean canReplaceCurrentItem = false;
        SoldierEquipmentSlot equipmentSlot = null;
        Iterator<SoldierEquipmentSlot> iterator = possibleSlots.iterator();
        while (iterator.hasNext() && !(canReplaceCurrentItem = ((ItemStackWithEffect)(currentItem = this.getItemBySlot(equipmentSlot = (slot = iterator.next())))).canBeReplaced(newItem))) {
        }
        if (canReplaceCurrentItem && this.canHoldItem(pStack)) {
            if (!currentItem.isEmpty()) {
                this.dropItemStackWithChance((ItemStackWithEffect)currentItem);
            }
            ItemStack copied = pStack;
            if (pStack.getCount() > effect.getMaxStackSize()) {
                copied = pStack.copyWithCount(effect.getMaxStackSize());
            }
            this.setItemSlot(equipmentSlot, copied);
            slotCallBack.slot(equipmentSlot);
            effect.executePickUpFunctions(this, copied);
            return copied;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack equipGoalItem(ItemStack stack, SoldierSlotCallback slotCallback) {
        if (this.workSelector.workRequiresItemPickUp() && this.carriedStack.isEmpty()) {
            slotCallback.carried();
            this.setCarriedStack(stack);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean couldEquipStack(@NotNull SoldierHoldableEffect effect) {
        AttackTypeProperty attackTypeStack;
        AttackTypeProperty attackTypeSelf = this.getAttackType();
        if (!attackTypeSelf.compatibleWith(attackTypeStack = effect.properties().attackType())) {
            return false;
        }
        if (effect.throwable()) {
            if (attackTypeStack.isSupportive()) {
                return effect.throwableType(RangedAttackType.HELPING);
            }
            if (attackTypeStack.fightsBack()) {
                return effect.throwableType(RangedAttackType.HARM);
            }
        }
        return true;
    }

    @Override
    public ItemEntity dropItemStack(ItemStack stack) {
        return this.spawnAtLocation(stack);
    }

    @Override
    public ItemStackWithEffect getItemBySlot(SoldierEquipmentSlot pSlot) {
        return switch (pSlot.getType()) {
            default -> throw new MatchException(null, null);
            case SoldierEquipmentSlot.Type.HAND -> (ItemStackWithEffect)this.soldierHandItems.get(pSlot.getIndex());
            case SoldierEquipmentSlot.Type.ARMOR -> (ItemStackWithEffect)this.soldierArmorItems.get(pSlot.getIndex());
            case SoldierEquipmentSlot.Type.BACKPACK -> (ItemStackWithEffect)this.soldierBackpackItems.get(pSlot.getIndex());
        };
    }

    @Override
    public void setItemSlot(SoldierEquipmentSlot pSlot, ItemStack pStack) {
        this.setItemSlot(pSlot, new ItemStackWithEffect(pStack));
    }

    @Override
    public void setItemSlot(SoldierEquipmentSlot pSlot, ItemStackWithEffect pStack) {
        this.verifyEquippedItem(pStack.stack());
        switch (pSlot.getType()) {
            case HAND: {
                this.soldierHandItems.set(pSlot.getIndex(), (Object)pStack);
                break;
            }
            case ARMOR: {
                this.soldierArmorItems.set(pSlot.getIndex(), (Object)pStack);
                break;
            }
            case BACKPACK: {
                this.soldierBackpackItems.set(pSlot.getIndex(), (Object)pStack);
            }
        }
        this.handleSlotChange(pSlot, pStack);
    }

    private void handleSlotChange(SoldierEquipmentSlot slot, ItemStackWithEffect stackWithEffect) {
        if (!this.level().isClientSide()) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)this, new SoldierItemChangePayload(this.getId(), slot, stackWithEffect.stack()));
        }
        this.updateSpecialProperties(stackWithEffect, slot);
        this.updateCombinedProperties(slot, stackWithEffect.effect());
        this.updateOtherProperties();
    }

    private void updateCombinedProperties(SoldierEquipmentSlot slot, @Nullable SoldierHoldableEffect effect) {
        if (effect != null) {
            this.propertyCombiner.addProperty(effect.predicate(), effect.properties(), slot);
        } else {
            this.propertyCombiner.removeProperty(slot);
        }
        this.propertyCombiner.addPropertyFromTeam(this.getClayTeam());
        this.propertyCombiner.combine();
    }

    private void initCombinedProperties() {
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            SoldierHoldableEffect effect = this.getItemBySlot(slot).effect();
            if (effect == null) continue;
            this.propertyCombiner.addProperty(effect.predicate(), effect.properties(), slot);
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)77);
        }
        this.propertyCombiner.addPropertyFromTeam(this.getClayTeam());
        this.propertyCombiner.combine();
    }

    @Deprecated
    public void setItemSlot(EquipmentSlot pSlot, ItemStack pStack) {
        SoldierEquipmentSlot.getFromSlot(pSlot).ifPresent(soldierSlot -> this.setItemSlot((SoldierEquipmentSlot)soldierSlot, pStack));
    }

    @Deprecated
    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot pSlot) {
        return SoldierEquipmentSlot.getFromSlot(pSlot).map(this::getItemBySlot).orElse(ItemStackWithEffect.EMPTY).stack();
    }

    public Iterable<ItemStack> getHandSlots() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierHandItems);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierArmorItems);
    }

    public Iterable<ItemStack> getBackpackSlots() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierBackpackItems);
    }

    @Override
    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorSlots(), this.getBackpackSlots());
    }

    public Iterable<ItemStackWithEffect> getAllSlotsWithEffect() {
        return Iterables.concat(this.soldierHandItems, this.soldierArmorItems, this.soldierBackpackItems);
    }

    @Override
    public SoldierPropertyMapReader allProperties() {
        return this.propertyCombiner;
    }

    private void updateSpecialProperties(ItemStackWithEffect effect, SoldierEquipmentSlot slot) {
        if (effect.isThrowable()) {
            this.stackWithProjectile = effect;
        }
        if (this.stackWithProjectile == null) {
            this.querySpecialProperties();
        }
    }

    private void querySpecialProperties() {
        for (ItemStackWithEffect stackWithEffect : this.getAllSlotsWithEffect()) {
            if (!stackWithEffect.isThrowable()) continue;
            this.stackWithProjectile = stackWithEffect;
        }
    }

    public boolean canPerformRangeAttack() {
        return this.stackWithProjectile != null;
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pVelocity) {
        if (this.stackWithProjectile == null) {
            return;
        }
        ThrowableItemCapability capability = this.stackWithProjectile.getThrowableCap();
        SoldierHoldableEffect holdableEffect = this.stackWithProjectile.effect();
        if (holdableEffect == null) {
            this.stackWithProjectile = null;
            return;
        }
        if (capability == null) {
            capability = new ThrowableItemCapability(){

                @Override
                @NotNull
                public Projectile createProjectile(Level level, LivingEntity shooter, SoldierHoldableEffect holdableEffect) {
                    ClaySoldierThrowableItemEntity pr = new ClaySoldierThrowableItemEntity(level, shooter, AbstractClaySoldierEntity.this.stackWithProjectile);
                    pr.setItem(AbstractClaySoldierEntity.this.stackWithProjectile.stack());
                    return pr;
                }
            };
        }
        capability.performRangedAttack(this, this.level(), pTarget, holdableEffect, pVelocity);
        holdableEffect.getRemovalConditions().forEach(condition -> {
            if (condition.shouldRemove(this, RemovalConditionContext.useRanged(this.stackWithProjectile.stack())) && this.stackWithProjectile.shrink(1) <= 0) {
                this.stackWithProjectile = ItemStackWithEffect.EMPTY;
            }
        });
    }

    public void indicateMeleeItemUse() {
        this.testForRemoval(RemovalConditionContext::useMelee, false);
    }

    private void testForRemoval(Function<ItemStack, RemovalConditionContext> contextBuilder, boolean onlyOne) {
        if (this.level().isClientSide()) {
            return;
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect stack = this.getItemBySlot(slot);
            SoldierHoldableEffect effect = stack.effect();
            if (effect == null) continue;
            RemovalConditionContext context = contextBuilder.apply(stack.stack());
            for (RemovalCondition condition : effect.getRemovalConditions()) {
                if (!condition.shouldRemove(this, context)) continue;
                this.setItemSlot(slot, stack.shrink(1) <= 0 ? ItemStackWithEffect.EMPTY : stack);
                if (!onlyOne) continue;
                return;
            }
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (!(source.getEntity() instanceof Player) && source.is(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE) && this.getHealth() * 3.0f < this.getMaxHealth() && this.allProperties().hasEvacuationProperty()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.allProperties().getEvacuationProperty().evacuate(serverLevel, this);
                this.testForRemoval(RemovalConditionContext::fireworkRocket, true);
            }
            return false;
        }
        this.testForRemoval(stack -> RemovalConditionContext.hurt(source, stack), false);
        if (source.is(DamageTypes.THROWN) && (entity = source.getEntity()) instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldierThrower = (AbstractClaySoldierEntity)entity;
            this.performCounterAttacks(soldierThrower, SpecialAttackType.MELEE);
            if (this.allProperties().canTeleport()) {
                this.teleportSoldier((LivingEntity)soldierThrower);
            }
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            amount -= amount * Math.clamp(this.allProperties().explosionResistance() * 0.08f, 0.0f, 1.0f);
        }
        if (!this.level().isClientSide()) {
            amount = this.allProperties().damageBlock().blocked(this.random, amount, source.is(DamageTypes.THROWN) || source.is(ModDamageTypes.CLAY_HURT));
        }
        return super.hurt(source, amount);
    }

    public boolean canSwim() {
        return this.allProperties().canSwim();
    }

    public int getMaxAirSupply() {
        int breathHold = this.allProperties() != null ? this.allProperties().breathHoldDuration() : 0;
        return Math.max(10, super.getMaxAirSupply() + breathHold * 100);
    }

    protected int decreaseAirSupply(int pCurrentAir) {
        if (this.allProperties().breathHoldDuration() >= 1000) {
            return pCurrentAir;
        }
        if (this.allProperties().breathHoldDuration() <= -200) {
            return super.decreaseAirSupply(pCurrentAir) * 30;
        }
        return super.decreaseAirSupply(pCurrentAir);
    }

    protected int increaseAirSupply(int currentAir) {
        return super.increaseAirSupply(Math.min(this.allProperties().breathHoldDuration(), 0) + currentAir);
    }

    @Override
    public double getDefaultAttackReach() {
        float blindnessMultiplier = 1.0f;
        MobEffectInstance blindnessEffect = this.getMobEffect((Holder<MobEffect>)MobEffects.BLINDNESS);
        if (blindnessEffect != null) {
            blindnessMultiplier = AbstractClaySoldierEntity.calcBlindnessReach(blindnessEffect.getAmplifier());
        }
        return ((double)0.7f * (double)this.getSoldierSize() + (double)this.allProperties().bonusAttackRange()) * (double)blindnessMultiplier;
    }

    private static float calcBlindnessReach(int amp) {
        return 1.0f - (float)(-Math.pow(2.0, -((float)amp + 1.0f)) + 1.0);
    }

    private void updateOtherProperties() {
        if (this.allProperties() != null) {
            if (this.allProperties().canSwim()) {
                this.setPathfindingMalus(PathType.WATER, 0.0f);
                this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
                this.navigation = this.waterNavigation;
            } else {
                this.setPathfindingMalus(PathType.WATER, PathType.WATER.getMalus());
                this.setPathfindingMalus(PathType.WATER_BORDER, PathType.WATER_BORDER.getMalus());
                this.navigation = this.groundNavigation;
            }
        }
    }

    public boolean isCurrentlyGlowing() {
        return super.isCurrentlyGlowing() || this.allProperties().hasGlowOutline();
    }

    @Override
    public boolean sameTeamAs(Entity other) {
        AttackTypeProperty attackType = this.getAttackType();
        if (attackType == AttackTypeProperty.AGGRESSIVE) {
            return false;
        }
        if (other instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity claySoldier = (AbstractClaySoldierEntity)other;
            if (attackType.isRoyalty() ? claySoldier.getAttackType() == attackType : claySoldier.getAttackType() == AttackTypeProperty.AGGRESSIVE) {
                return false;
            }
        }
        return super.sameTeamAs(other);
    }

    public boolean canSeeInvis() {
        return this.allProperties().canSeeInvis();
    }

    public double getVisibilityPercent(@Nullable Entity pLookingEntity) {
        AbstractClaySoldierEntity claySoldier;
        if (pLookingEntity instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)pLookingEntity).canSeeInvis()) {
            return 1.0;
        }
        return super.getVisibilityPercent(pLookingEntity);
    }

    protected void updateInvisibilityStatus() {
        super.updateInvisibilityStatus();
    }

    private void explodeTick() {
        int swellDir;
        this.oldSwell = this.swell;
        if (this.isIgnited()) {
            this.setSwellDir(1);
        }
        if ((swellDir = this.getSwellDir()) > 0 && this.swell == 0) {
            this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
            this.gameEvent((Holder)GameEvent.PRIME_FUSE);
        }
        this.swell += swellDir;
        if (this.swell < 0) {
            this.swell = 0;
        }
        if (this.swell >= this.maxSwell) {
            this.swell = this.maxSwell;
            this.explodeSoldier();
        }
    }

    public void die(DamageSource damageSource) {
        if (ClaySoldiersCommon.COMMON_HOOKS.onLivingDeath((LivingEntity)this, damageSource)) {
            return;
        }
        this.workSelector.resetGoal();
        if (!this.isRemoved() && !this.dead) {
            if (this.allProperties().hasPropertyType(SoldierPropertyTypes.DEATH_EXPLOSION.get())) {
                this.ignite();
                if (this.swell < this.maxSwell) {
                    return;
                }
            } else {
                this.spawnDeathEffect();
                if (this.level().isClientSide()) {
                    this.spawnFireWorks();
                }
            }
            WraithProperty wraithProperty = this.allProperties().wraith();
            Entity entity = damageSource.getEntity();
            LivingEntity livingentity = this.getKillCredit();
            if (this.deathScore >= 0 && livingentity != null) {
                livingentity.awardKillScore((Entity)this, this.deathScore, damageSource);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            if (!this.level().isClientSide && this.hasCustomName()) {
                LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.killedEntity(serverlevel, (LivingEntity)this)) {
                    ReviveResult reviveResult = this.reviveSelf(serverlevel);
                    if (reviveResult.dropInventory()) {
                        this.dropAllDeathLoot(serverlevel, damageSource);
                    }
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.createWitherRose(livingentity);
                    if (reviveResult == ReviveResult.FAIL && wraithProperty != null) {
                        ClayWraithEntity.spawnWraith(serverlevel, this, wraithProperty.duration(), wraithProperty.onSpawnEffect());
                    }
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.setPose(Pose.DYING);
        }
    }

    protected boolean dropInventoryOnDeath() {
        return true;
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel level, DamageSource pSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(level, pSource, pRecentlyHit);
        if (this.dropInventoryOnDeath()) {
            AbstractClaySoldierEntity.dropInventory(level, this::getItemBySlot, (slot, stack) -> {
                this.spawnAtLocation((ItemStack)stack);
                this.setItemSlot((SoldierEquipmentSlot)slot, ItemStackWithEffect.EMPTY);
            });
            if (!this.getCarriedStack().isEmpty()) {
                this.dropItemStack(this.getCarriedStack());
            }
        }
    }

    public static void dropInventory(ServerLevel level, Function<SoldierEquipmentSlot, ItemStackWithEffect> equipment, BiConsumer<SoldierEquipmentSlot, ItemStack> dropInWorld) {
        if (!level.getGameRules().getBoolean(ClaySoldiersCommon.CLAY_SOLDIER_INVENTORY_DROP_RULE)) {
            return;
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect stack = equipment.apply(slot);
            if (stack.isEmpty() || EnchantmentHelper.has((ItemStack)stack.stack(), (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !(level.getRandom().nextFloat() < stack.dropRate())) continue;
            dropInWorld.accept(slot, stack.stack());
        }
    }

    protected void tickDeath() {
        if (this.isIgnited() && this.swell <= this.maxSwell) {
            this.explodeTick();
            return;
        }
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public float getSwelling(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int pState) {
        this.entityData.set(DATA_SWELL_DIR, (Object)pState);
    }

    private void explodeSoldier() {
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)81);
            float explosionPower = ((Float)this.allProperties().getValueOrDfault(SoldierPropertyTypes.DEATH_EXPLOSION)).floatValue();
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.explosionRadius * explosionPower, Level.ExplosionInteraction.NONE);
            this.discard();
            this.spawnDeathEffect();
        }
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 81) {
            this.spawnFireWorks();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.entityData.get(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.entityData.set(DATA_IS_IGNITED, (Object)true);
    }

    private void spawnDeathEffect() {
        if (this.level().isClientSide()) {
            return;
        }
        List<MobEffectInstance> collection = this.allProperties().getDeathCloudEffects();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloud.setRadius(1.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }

    private void spawnFireWorks() {
        ArrayList<FireworkExplosion> fireworkExplosions = new ArrayList<FireworkExplosion>();
        for (ItemStack stack : this.getAllSlots()) {
            FireworkExplosion exp = (FireworkExplosion)stack.get(DataComponents.FIREWORK_EXPLOSION);
            if (exp == null) continue;
            fireworkExplosions.add(exp);
        }
        if (!fireworkExplosions.isEmpty()) {
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), 0.0, 1.0, 0.0, fireworkExplosions);
        }
    }

    public float getSoldierSize() {
        if (this.allProperties() == null) {
            return 1.0f;
        }
        return Math.clamp(0.2f, this.allProperties().getSoldierSize(), 3.0f);
    }

    public float getScale() {
        if (!this.level().isClientSide()) {
            return super.getScale() * this.getSoldierSize();
        }
        return this.delayedScale * super.getScale();
    }

    public boolean fightsBack() {
        return this.getAttackType().fightsBack();
    }

    @Override
    protected boolean targetPredicate(LivingEntity target) {
        return this.getAttackType().canAttack(this, target);
    }

    protected boolean specificTargetPredicate(LivingEntity target) {
        if (this.canPerformRangeAttack()) {
            return this.allProperties().specialAttacks(SpecialAttackType.RANGED, this.getAttackType().forType()).stream().anyMatch(s -> s.shouldAttackTarget(target));
        }
        return this.allProperties().specialAttacks(SpecialAttackType.MELEE, this.getAttackType().forType()).stream().anyMatch(s -> s.shouldAttackTarget(target));
    }

    @Override
    public AttackTypeProperty getAttackType() {
        if (this.allProperties() != null) {
            AttackTypeProperty attackType = this.allProperties().attackType();
            return attackType == AttackTypeProperty.NORMAL ? this.defaultAttackType : attackType;
        }
        return this.defaultAttackType;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.moveCloak(this.getX(), this.getY(), this.getZ());
            this.delaySizeScale();
        }
    }

    private void delaySizeScale() {
        float actualSize = this.getSoldierSize();
        if (this.delayedScale == actualSize) {
            return;
        }
        if (this.delayedScale < actualSize) {
            this.delayedScale += 0.1f;
            if (this.delayedScale > actualSize) {
                this.delayedScale = actualSize;
            }
        } else {
            this.delayedScale -= 0.1f;
            if (this.delayedScale < actualSize) {
                this.delayedScale = actualSize;
            }
        }
    }

    public void rideTick() {
        if (this.level().isClientSide()) {
            this.oBob = this.bob;
            this.bob = 0.0f;
        }
        this.matchBodyRotToRidden();
        super.rideTick();
    }

    private void matchBodyRotToRidden() {
        Entity entity;
        if (this.getRidingPose().shouldMatchBodyRot() && (entity = this.getVehicle()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.yBodyRot = entity2.yBodyRot;
        }
    }

    public void aiStep() {
        if (this.level().isClientSide()) {
            this.oBob = this.bob;
            float movementSpeed = this.onGround() && !this.isDeadOrDying() && !this.isSwimming() ? Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance()) : 0.0f;
            this.bob += (movementSpeed - this.bob) * 0.4f;
        } else {
            Mob vehicle;
            Entity entity;
            if (this.tickCount % 20 == 0 && (entity = this.getVehicle()) instanceof Mob) {
                Mob living = (Mob)entity;
                living.setTarget(this.getTarget());
            }
            if (this.tickCount % 100 == 0 && (entity = this.getVehicle()) instanceof Mob && !this.canRideEntity((LivingEntity)(vehicle = (Mob)entity))) {
                this.stopRiding();
            }
            Vec3 movement = this.getDeltaMovement();
            if (this.isFalling() && this.allProperties().canGlide()) {
                this.setDeltaMovement(movement.multiply(1.0, 0.7, 1.0));
            }
            this.dropCarriedTick();
        }
        this.updateSwingTime();
        super.aiStep();
    }

    protected void moveCloak(double x, double y, double z) {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double deltaX = x - this.xCloak;
        double deltaY = y - this.yCloak;
        double deltaZ = z - this.zCloak;
        if (deltaX > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (deltaZ > 10.0) {
            this.zCloakO = this.zCloak = z;
        }
        if (deltaY > 10.0) {
            this.yCloakO = this.yCloak = y;
        }
        if (deltaX < -10.0) {
            this.xCloakO = this.xCloak = x;
        }
        if (deltaZ < -10.0) {
            this.zCloakO = this.zCloak = z;
        }
        if (deltaY < -10.0) {
            this.yCloakO = this.yCloak = y;
        }
        this.xCloak += deltaX * 0.25;
        this.zCloak += deltaZ * 0.25;
        this.yCloak += deltaY * 0.25;
    }

    public void handleSpawnPayload(ClaySoldierSpawnPayload payload) {
        this.setItemSlot(SoldierEquipmentSlot.CAPE, payload.getCape());
        this.setItemSlot(SoldierEquipmentSlot.BACKPACK, payload.getBackpack1());
        this.setItemSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE, payload.getBackpack2());
        for (ReviveType type : ReviveType.values()) {
            this.setReviveOnCooldown(type, payload.getReviveCooldowns().get(type.ordinal()));
        }
        this.skinVariantId = payload.getSkinId();
        this.setCarriedStack(payload.getCarried());
        this.initCombinedProperties();
        this.setDataWorkStatus(payload.getWorkStatus());
    }

    @Override
    public void sendSpawnPayload(ServerPlayer tracking) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayer(tracking, new ClaySoldierSpawnPayload(this));
    }

    @Override
    public boolean canMountEntity(LivingEntity livingEntity) {
        if (!livingEntity.getPassengers().isEmpty()) {
            return false;
        }
        return this.canRideEntity(livingEntity);
    }

    public boolean canRideEntity(LivingEntity livingEntity) {
        return ClaySoldierRideableMap.test(livingEntity, this);
    }

    @Override
    public boolean isAbleToRide() {
        return !this.isPassenger() && this.getSoldierSize() <= 1.3f;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity pEntity, EntityDimensions pDimensions, float pPartialTick) {
        return super.getPassengerAttachmentPoint(pEntity, pDimensions, pPartialTick).add(0.0, 0.02 * (double)this.getScale(), 0.0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity controller = super.getControllingPassenger();
        return controller instanceof ClayMobEntity ? null : controller;
    }

    @Override
    public float getCustomArmorValue() {
        return this.allProperties().protection();
    }

    public float getCustomArmorToughness() {
        return this.allProperties().heavy();
    }

    protected float getDamageAfterArmorAbsorb(DamageSource pDamageSource, float pDamageAmount) {
        if (!pDamageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.hurtArmor(pDamageSource, pDamageAmount);
            pDamageAmount = CombatRules.getDamageAfterAbsorb((LivingEntity)this, (float)pDamageAmount, (DamageSource)pDamageSource, (float)this.getArmorValue(), (float)((float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS) + this.getCustomArmorToughness()));
        }
        return pDamageAmount;
    }

    public int getArmorValue() {
        return super.getArmorValue() + (int)this.getCustomArmorValue();
    }

    public boolean hasShieldInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(SoldierEquipmentSlot.MAINHAND).isShield();
        }
        return this.getItemBySlot(SoldierEquipmentSlot.OFFHAND).isShield();
    }

    public int getTeamColor() {
        return this.getClayTeam().getColor((LivingEntity)this, 0.0f);
    }

    @Override
    public void setOffsetColor(ColorHelper color) {
        this.colorGetter.setColor(color);
    }

    @Override
    public void addOffsetColor(ColorHelper color) {
        this.dyeSoldier(color);
    }

    @Override
    public ColorHelper getOffsetColor() {
        return this.colorGetter.getColor();
    }

    private void dyeSoldier(ColorHelper color) {
        this.setOffsetColor(this.getOffsetColor().addColor(color));
    }

    public boolean canRevive() {
        return this.reviveProperty().canRevive();
    }

    public boolean canBeRevived() {
        return this.getAttackType().canBeRevived();
    }

    private ReviveProperty reviveProperty() {
        return this.allProperties().reviveType();
    }

    protected ReviveResult reviveSelf(ServerLevel serverLevel) {
        if (this.canBeRevived()) {
            Iterator<AbstractClaySoldierEntity> iterator = this.findReviver(new AABB(this.blockPosition()).inflate(4.0));
            while (iterator.hasNext()) {
                AbstractClaySoldierEntity reviver = iterator.next();
                ReviveResult result = reviver.reviveProperty().reviveSoldier(serverLevel, this, reviver);
                if (!result.success()) continue;
                return result;
            }
        }
        return ReviveResult.FAIL;
    }

    private Iterator<AbstractClaySoldierEntity> findReviver(AABB area) {
        return this.level().getEntitiesOfClass(AbstractClaySoldierEntity.class, area, AbstractClaySoldierEntity::canRevive).stream().filter(s -> !s.equals(this)).sorted(this::createReviveComparator).iterator();
    }

    private int createReviveComparator(AbstractClaySoldierEntity o1, AbstractClaySoldierEntity o2) {
        return (int)(o2.distanceTo((Entity)this) + (float)this.reviveValue(o2) - (o1.distanceTo((Entity)this) + (float)this.reviveValue(o1)));
    }

    private int reviveValue(AbstractClaySoldierEntity soldier) {
        return soldier.sameTeamAs((Entity)this) ? -1 : 0;
    }

    public void setReviveOnCooldown(ReviveType type, int cooldown) {
        if (cooldown <= 0) {
            return;
        }
        if (!this.level().isClientSide) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)this, new ClaySoldierReviveCooldownPayload(this.getId(), type, cooldown));
        }
        this.reviveTypeCooldown.put(type, this.level().getGameTime() + (long)cooldown);
    }

    public boolean isReviveTypeOffCooldown(ReviveType type) {
        Long timeStamp = this.reviveTypeCooldown.get(type);
        if (timeStamp == null) {
            return true;
        }
        return timeStamp <= this.level().getGameTime();
    }

    public Map<ReviveType, Integer> getReviveTypeCooldown() {
        return this.reviveTypeCooldown.entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry((ReviveType)e.getKey(), (Long)e.getValue() - this.level().getGameTime())).filter(e -> (Long)e.getValue() > 0L).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Long)e.getValue()).intValue(), (e1, e2) -> e1, () -> new EnumMap(ReviveType.class)));
    }

    public boolean isZombie() {
        return this.getAttackType() == AttackTypeProperty.ZOMBIE;
    }

    @Override
    public ClayMobEntity asClayMob() {
        return this;
    }

    @Override
    public <T extends ClaySoldierInventoryHandler> void copyInventory(T toCopyTo) {
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect item = this.getItemBySlot(slot);
            SoldierHoldableEffect effect = item.effect();
            if (item.isEmpty()) continue;
            if (effect != null && toCopyTo.couldEquipStack(effect)) {
                toCopyTo.setItemSlot(slot, item.copy());
                effect.executePickUpFunctions(toCopyTo, item.stack());
                continue;
            }
            this.dropItemSlotWithChance(slot);
        }
    }

    @Override
    protected OptionalInt openMenuScreen(Player player) {
        return ClaySoldiersCommon.COMMON_HOOKS.openMenu(player, (MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new ClaySoldierMenu(id, inventory, this), this.getInventoryName()), this.getId());
    }

    @Override
    protected Component getInventoryName() {
        MutableComponent name = Component.empty();
        Component attackTypeDisplayName = this.getAttackType().getAnimatedDisplayName((LivingEntity)this);
        if (attackTypeDisplayName != null) {
            name.append(attackTypeDisplayName);
            name.append(CommonComponents.SPACE);
        }
        name.append(this.getDisplayName());
        return name;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.allProperties().canGlide()) {
            return false;
        }
        return super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    protected byte getGliderItemSlot() {
        if (this.lastGliderSlot == -2) {
            for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
                if (!this.getItemBySlot(slot).isGlider()) continue;
                this.lastGliderSlot = (byte)slot.ordinal();
                return this.lastGliderSlot;
            }
            this.lastGliderSlot = (byte)-1;
            return this.lastGliderSlot;
        }
        if (this.lastGliderSlot >= 0 && this.getItemBySlot(SoldierEquipmentSlot.values()[this.lastGliderSlot]).isGlider()) {
            return this.lastGliderSlot;
        }
        this.lastGliderSlot = (byte)-1;
        return this.lastGliderSlot;
    }

    public boolean isFallingWithGlider() {
        return this.isFalling() && this.getGliderItemSlot() >= 0 && this.getVehicle() == null;
    }

    public boolean isFalling() {
        return !this.onGround() && this.getDeltaMovement().y < 0.0;
    }

    public boolean isFallingWithGlider(SoldierEquipmentSlot slot) {
        return this.isFallingWithGlider() && this.getGliderItemSlot() == (byte)slot.ordinal();
    }

    public boolean handsOccupied(SoldierEquipmentSlot slot) {
        return this.isFallingWithGlider() || !this.getCarriedStack().isEmpty() || this.getItemBySlot(slot).isShield();
    }

    public ItemStack getGliderItem() {
        byte slot = this.getGliderItemSlot();
        if (slot < 0) {
            return ItemStack.EMPTY;
        }
        return this.getItemBySlot(SoldierEquipmentSlot.values()[slot]).stack();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        if (this.allProperties().immunity().isImmune((Holder<MobEffect>)effectInstance.getEffect())) {
            return false;
        }
        return super.canBeAffected(effectInstance);
    }

    @Override
    public boolean addMobEffect(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        return this.addEffect(pEffectInstance, pEntity);
    }

    @Override
    @Nullable
    public MobEffectInstance getMobEffect(Holder<MobEffect> pEffect) {
        return this.getEffect(pEffect);
    }

    @Override
    public boolean removeMobEffect(Holder<MobEffect> pEffect) {
        return this.removeEffect(pEffect);
    }

    public boolean removeEffect(Holder<MobEffect> pEffect) {
        if (this.allProperties().immunity().isPersistent(pEffect)) {
            return false;
        }
        return super.removeEffect(pEffect);
    }

    @Override
    public void readItemPersistentData(CompoundTag tag) {
    }

    @Override
    protected void tryToSit(@Nullable Player player, boolean sitting) {
        if (player != null && this.getAttackType().isRoyalty()) {
            this.level().getEntitiesOfClass(AbstractClaySoldierEntity.class, new AABB(this.getOnPos()).inflate(5.0), c -> c != this && c.isOwnedBy(player)).forEach(soldier -> soldier.tryToSit(null, sitting));
        }
        super.tryToSit(player, sitting);
    }

    @Override
    protected void modifyPickResult(ItemStack stack) {
        ClaySoldierSpawnItem.setClayMobTeam(stack, this.getClayTeamType(), (HolderLookup.Provider)this.level().registryAccess());
    }

    public RidingPose getRidingPose() {
        Entity vehicle = this.getVehicle();
        if (vehicle != null) {
            if (vehicle.getType() == EntityType.RABBIT) {
                return RidingPose.RABBIT;
            }
            if (vehicle.getType() == EntityType.FIREWORK_ROCKET) {
                return RidingPose.FIREWORK;
            }
            if (vehicle.getType() == EntityType.ENDERMITE) {
                return RidingPose.ENDERMITE;
            }
        }
        return RidingPose.DEFAULT;
    }

    protected EntityDimensions getDefaultDimensions(Pose pPose) {
        if (Pose.SITTING == pPose && !this.isPassenger()) {
            return super.getDefaultDimensions(pPose).scale(2.0f, 0.7f);
        }
        return super.getDefaultDimensions(pPose);
    }

    public int getSkinVariant() {
        return this.skinVariantId;
    }

    public ItemStack getCarriedStack() {
        return this.carriedStack;
    }

    public void setCarriedStack(ItemStack carriedStack) {
        this.carriedStack = carriedStack;
        if (!this.level().isClientSide()) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)this, new SoldierCarriedChangePayload(this.getId(), (Holder<Item>)carriedStack.getItemHolder()));
        }
    }

    public void dropCarried() {
        this.dropItemStack(this.getCarriedStack().copy());
        this.setCarriedStack(ItemStack.EMPTY);
    }

    public void dropCarriedTick() {
        if (!this.workSelector.workRequiresItemCarrying()) {
            this.dropCarried();
        }
    }

    @Override
    public boolean unableToMoveToOwner() {
        return this.workSelector.shouldStayAtWork() || super.unableToMoveToOwner();
    }

    @Override
    @Nullable
    public Component getWorkStatus() {
        return this.statusManger.getStatusDisplayName();
    }

    @Override
    @Nullable
    public AssignablePoiCapability getPoiCapability() {
        return this.workSelector.isWorking() ? null : super.getPoiCapability();
    }

    public void setDataWorkStatus(byte statusCode) {
        this.entityData.set(DATA_WORK_STATUS, (Object)statusCode);
    }

    public byte getDataWorkStatus() {
        return (Byte)this.entityData.get(DATA_WORK_STATUS);
    }

    public Component getCombatDisplayName() {
        if (this.hasPoiPos()) {
            return Component.translatable((String)DEFENDING_AREA_LANG);
        }
        return Component.translatable((String)PROTECTING_OWNER_LANG);
    }

    @Override
    public int unpackDynamicColor(ColorHelper color, float partialTicks) {
        return color.getColor((LivingEntity)this, 0.0f);
    }

    private void teleportSoldier(LivingEntity target) {
        if (this.getAttackType().fightsBack()) {
            Object moving = this.getVehicle();
            if (moving == null) {
                this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_TARGET), true);
                moving = this;
            }
            moving.teleportTo(target.getX(), target.getY() + 0.3, target.getZ());
            this.setTarget(target);
            this.level().gameEvent((Holder)GameEvent.TELEPORT, this.position(), GameEvent.Context.of((Entity)this));
            SoundEvent soundevent = SoundEvents.CHORUS_FRUIT_TELEPORT;
            SoundSource soundsource = SoundSource.NEUTRAL;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundevent, soundsource);
            this.resetFallDistance();
        } else {
            Items.CHORUS_FRUIT.finishUsingItem(Items.CHORUS_FRUIT.getDefaultInstance(), this.level(), (LivingEntity)this);
            this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_SAFETY), true);
        }
    }

    @Override
    public boolean shouldTryTeleportToOwner() {
        if (!this.allProperties().canTeleportToOwner()) {
            return false;
        }
        Player livingentity = this.getClayTeamOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getClayTeamOwner()) >= 144.0;
    }

    @Override
    public boolean tryToTeleportToOwner() {
        if (super.tryToTeleportToOwner()) {
            this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_OWNER), true);
            return true;
        }
        return false;
    }

    public boolean isInCombat() {
        return this.inCombat;
    }

    public void onEnterCombat() {
        super.onEnterCombat();
        this.inCombat = true;
    }

    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.inCombat = false;
    }

    public WalkAnimationState getWalkAnimation() {
        return this.walkAnimation;
    }

    @Override
    public List<String> getInfoState() {
        List<String> list = super.getInfoState();
        list.add("Properties: " + String.valueOf(this.allProperties()));
        list.add("Status: " + String.valueOf(this.statusManger));
        list.add("WorkSelector: " + String.valueOf(this.workSelector));
        list.add("ReviveCooldown: " + String.valueOf(this.reviveTypeCooldown));
        return list;
    }

    public boolean startRiding(Entity entity, boolean force) {
        boolean result = super.startRiding(entity, force);
        this.updateRidingProperties();
        ClaySoldierRideableMap.onRide(entity, this);
        return result;
    }

    public void stopRiding() {
        super.stopRiding();
        this.updateRidingProperties();
    }

    private void updateRidingProperties() {
        Entity vehicle = this.getVehicle();
        SoldierVehicleProperties properties = vehicle != null ? Objects.requireNonNullElse(ClaySoldiersCommon.DATA_MAP.getVehicleProperties(vehicle.getType()), SoldierVehicleProperties.EMPTY) : SoldierVehicleProperties.EMPTY;
        this.propertyCombiner.addVehicle(properties);
        this.propertyCombiner.combine();
    }

    public void onBounce() {
        this.testForRemoval(RemovalConditionContext::bounce, true);
    }

    @Override
    @NotNull
    public RandomSource getClaySoldierRandom() {
        return this.getRandom();
    }

    public static enum RidingPose {
        DEFAULT(false),
        FIREWORK(false),
        RABBIT(true),
        ENDERMITE(true);

        private final boolean matchBody;

        private RidingPose(boolean matchBody) {
            this.matchBody = matchBody;
        }

        public boolean shouldMatchBodyRot() {
            return this.matchBody;
        }
    }
}

