/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import net.bumblebee.claysoldiers.claypoifunction.ClaySoldierInventorySetter;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClaySoldierInventoryHandler
extends ClaySoldierInventoryQuery,
ClaySoldierInventorySetter {
    @Override
    public void setItemSlot(SoldierEquipmentSlot var1, ItemStack var2);

    @Override
    public void setItemSlot(SoldierEquipmentSlot var1, ItemStackWithEffect var2);

    @Override
    public ItemStackWithEffect getItemBySlot(SoldierEquipmentSlot var1);

    @Override
    default public boolean setSlotIfEmpty(SoldierEquipmentSlot slot, ItemStack stack) {
        if (this.getItemBySlot(slot).isEmpty()) {
            this.setItemSlot(slot, stack);
            return true;
        }
        return false;
    }

    @Override
    default public void setSlotAndDrop(SoldierEquipmentSlot slot, ItemStack stack) {
        this.dropItemStack(this.getItemBySlot(slot));
        this.setItemSlot(slot, stack);
    }

    @Override
    @Nullable
    public ItemEntity dropItemStack(ItemStack var1);

    @Override
    @Nullable
    default public ItemEntity dropItemSlotWithChance(SoldierEquipmentSlot slot) {
        return this.dropItemStackWithChance(this.getItemBySlot(slot));
    }

    @Override
    @Nullable
    default public ItemEntity dropItemStack(ItemStackWithEffect stackWithEffect) {
        return this.dropItemStack(stackWithEffect.stack());
    }

    @Override
    @Nullable
    default public ItemEntity dropItemStackWithChance(ItemStackWithEffect stackWithEffect) {
        if (this.getClaySoldierRandom().nextFloat() < stackWithEffect.dropRate()) {
            return this.dropItemStack(stackWithEffect);
        }
        return null;
    }

    @Override
    default public boolean increaseEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        MobEffectInstance current = this.getMobEffect((Holder<MobEffect>)effectInstance.getEffect());
        if (current == null) {
            return this.addMobEffect(effectInstance, entity);
        }
        return this.addMobEffect(new MobEffectInstance(effectInstance.getEffect(), effectInstance.getDuration() + current.getDuration(), effectInstance.getAmplifier() + effectInstance.getAmplifier()), entity);
    }

    public boolean couldEquipStack(@NotNull SoldierHoldableEffect var1);
}

