/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public interface ClaySoldierLike {
    public ClayMobEntity asClayMob();

    default public <T extends ClayMobEntity> T convertToSoldier(@NotNull EntityType<T> pEntityType, Consumer<T> applyEffect) {
        if (this.asClayMob().isRemoved()) {
            return null;
        }
        ClayMobEntity convertTo = (ClayMobEntity)pEntityType.create(this.asClayMob().level());
        if (convertTo == null) {
            return null;
        }
        this.copyBasePropertiesTo(convertTo, true);
        applyEffect.accept(convertTo);
        this.asClayMob().level().addFreshEntity((Entity)convertTo);
        if (this.asClayMob().isPassenger()) {
            Entity entity = this.asClayMob().getVehicle();
            this.asClayMob().stopRiding();
            convertTo.startRiding(entity, true);
        }
        this.asClayMob().discard();
        return (T)convertTo;
    }

    default public <T extends ClayMobEntity> void copyBasePropertiesTo(T toCopyTo, boolean copyInventory) {
        toCopyTo.copyPosition((Entity)this.asClayMob());
        toCopyTo.setBaby(this.asClayMob().isBaby());
        toCopyTo.setNoAi(this.asClayMob().isNoAi());
        if (this.asClayMob().hasCustomName()) {
            toCopyTo.setCustomName(this.asClayMob().getCustomName());
            toCopyTo.setCustomNameVisible(this.asClayMob().isCustomNameVisible());
        }
        if (this.asClayMob().isPersistenceRequired()) {
            toCopyTo.setPersistenceRequired();
        }
        toCopyTo.setInvulnerable(this.asClayMob().isInvulnerable());
        if (copyInventory && toCopyTo instanceof ClaySoldierInventoryHandler) {
            ClaySoldierInventoryHandler inventoryHandler = (ClaySoldierInventoryHandler)((Object)toCopyTo);
            this.copyInventory(inventoryHandler);
        }
        toCopyTo.setSpawnedFrom(this.asClayMob().getSpawnedFrom(), this.asClayMob().dropSpawnedFrom());
        if (this.asClayMob().isPassenger()) {
            Entity entity = this.asClayMob().getVehicle();
            this.asClayMob().stopRiding();
            toCopyTo.startRiding(entity, true);
        }
    }

    public <T extends ClaySoldierInventoryHandler> void copyInventory(T var1);

    public void readItemPersistentData(CompoundTag var1);

    default public void onConversion(ClayMobEntity oldSoldier, CompoundTag tag) {
    }
}

