/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.UndeadClaySoldier;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ZombieClaySoldierEntity
extends UndeadClaySoldier {
    private static final EntityDataAccessor<String> PREVIOUS_TEAM_SYNC = SynchedEntityData.defineId(ZombieClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final String CURABLE_TAG = "Curable";
    public static final String PICK_ITEMS_TAG = "PickUpItems";
    public static final String MATCH_TEAMS = "match_teams";
    private boolean curable = true;
    private boolean canPickItems = false;
    private IClayMobTeamReference cachedPrevTeam = null;

    public ZombieClaySoldierEntity(EntityType<? extends ZombieClaySoldierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.ZOMBIE);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        ResourceLocation prevTeamId = ClayMobTeam.read(pCompound, "zombie");
        if (ClayMobTeamManger.isValidTeam(prevTeamId, this.registryAccess())) {
            this.setPreviousTeam(prevTeamId);
        } else {
            this.setClayTeamType(ClayMobTeamManger.DEFAULT_TYPE);
        }
        this.setCurable(pCompound.getBoolean(CURABLE_TAG));
        this.setCanPickItems(pCompound.getBoolean(PICK_ITEMS_TAG));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        ClayMobTeam.save(this.getPreviousTeamId(), pCompound, "zombie");
        pCompound.putBoolean(CURABLE_TAG, this.isCurable());
        pCompound.putBoolean(PICK_ITEMS_TAG, this.canPickItems());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PREVIOUS_TEAM_SYNC, (Object)ClayMobTeamManger.DEFAULT_TYPE.toString());
    }

    @NotNull
    public ClayMobTeam getPreviousTeam() {
        ResourceLocation prevKey = this.getPreviousTeamId();
        if (this.cachedPrevTeam == null || !this.cachedPrevTeam.isValidForKey(prevKey)) {
            this.cachedPrevTeam = ClayMobTeamManger.getReferenceOrDefault(prevKey, this.registryAccess(), () -> {
                this.setPreviousTeam(ClayMobTeamManger.NO_TEAM_TYPE);
                ClayMobTeamManger.LOGGER.error("{} has a Previous Team ({}) that does not exist anymore", (Object)this.getClass().getSimpleName(), (Object)prevKey);
            });
        }
        return this.cachedPrevTeam == null ? ClayMobTeamManger.ERROR : this.cachedPrevTeam.value();
    }

    public ResourceLocation getPreviousTeamId() {
        return ResourceLocation.parse((String)((String)this.entityData.get(PREVIOUS_TEAM_SYNC)));
    }

    public void setPreviousTeam(ResourceLocation variant) {
        this.entityData.set(PREVIOUS_TEAM_SYNC, (Object)variant.toString());
    }

    @Override
    public boolean isAbleToRide() {
        return false;
    }

    @Override
    public boolean wantsToPickUp(ItemStack pStack) {
        return this.canPickItems && super.wantsToPickUp(pStack) || this.isItemStackHelm(pStack);
    }

    public boolean previousTeamSameAs(ClayMobEntity claySoldier) {
        if (!this.getPreviousTeam().isCooperative() || claySoldier.hasNoTeam()) {
            return false;
        }
        return this.getPreviousTeamId().equals((Object)claySoldier.getClayTeamType());
    }

    public boolean isCurable() {
        return this.curable;
    }

    public void setCurable(boolean curable) {
        this.curable = curable;
    }

    public void cureZombieSoldier() {
        if (!this.curable) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ModEntityTypes.CLAY_SOLDIER_ENTITY.get().spawn(serverLevel, curedSoldier -> {
                this.copyInventory(curedSoldier);
                curedSoldier.setClayTeamType(this.getPreviousTeamId());
            }, this.blockPosition(), MobSpawnType.CONVERSION, false, false);
            this.discard();
        }
    }

    @Override
    public void readItemPersistentData(CompoundTag tag) {
        if (tag.contains(CURABLE_TAG)) {
            this.setCurable(tag.getBoolean(CURABLE_TAG));
        }
        if (tag.contains(PICK_ITEMS_TAG)) {
            this.setCanPickItems(tag.getBoolean(PICK_ITEMS_TAG));
        }
    }

    public boolean canPickItems() {
        return this.canPickItems;
    }

    public void setCanPickItems(boolean canPickItems) {
        this.canPickItems = canPickItems;
    }

    @Override
    public void onConversion(ClayMobEntity oldSoldier, CompoundTag tag) {
        if (tag.contains(MATCH_TEAMS) && tag.getBoolean(MATCH_TEAMS)) {
            this.setPreviousTeam(oldSoldier.getClayTeamType());
        }
    }

    @Override
    public boolean isZombie() {
        return true;
    }
}

