/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier.status;

import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SoldierStatusManager
implements SoldierStatusHolder {
    public static final String SITTING_LANG = "clay_mob_status.csr.sitting";
    public static final String USING_POI_LANG = "clay_mob_status.csr.using_poi";
    private final List<Supplier<SoldierStatusHolder>> statuses;

    public SoldierStatusManager(List<Supplier<SoldierStatusHolder>> statuses) {
        this.statuses = statuses;
    }

    public static SoldierStatusManager initDefault(AbstractClaySoldierEntity soldier, Supplier<SoldierStatusHolder> workStatus) {
        return new SoldierStatusManager(List.of(() -> SoldierStatusManager.createSittingStatus(soldier), workStatus, () -> SoldierStatusManager.createCombatOwnerAndPoiStatus(soldier)));
    }

    public String toString() {
        Component displayName = this.getStatusDisplayName();
        return "SoldierStatusManager{(%s) %s}".formatted(this.statuses.size(), displayName == null ? "Null" : displayName.getString());
    }

    @Override
    public Component getStatusDisplayName() {
        for (Supplier<SoldierStatusHolder> soldierStatusHolderSupplier : this.statuses) {
            Component status = soldierStatusHolderSupplier.get().getStatusDisplayName();
            if (status == null) continue;
            return status;
        }
        return null;
    }

    private static SoldierStatusHolder createSittingStatus(final AbstractClaySoldierEntity soldier) {
        return new SoldierStatusHolder(){

            @Override
            @Nullable
            public Component getStatusDisplayName() {
                return soldier.isInSittingPose() ? Component.translatable((String)SoldierStatusManager.SITTING_LANG) : null;
            }
        };
    }

    private static SoldierStatusHolder createCombatOwnerAndPoiStatus(final AbstractClaySoldierEntity soldier) {
        return new SoldierStatusHolder(){

            @Override
            @Nullable
            public Component getStatusDisplayName() {
                if (soldier.usingPoi()) {
                    return Component.translatable((String)SoldierStatusManager.USING_POI_LANG);
                }
                if (!soldier.getAttackType().fightsBack() || soldier.getClayTeamOwnerUUID() == null) {
                    return null;
                }
                return soldier.getCombatDisplayName();
            }
        };
    }
}

