/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.throwables;

import com.mojang.serialization.DynamicOps;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class ClaySoldierSnowball
extends Snowball {
    private static final String PROPERTIES_TAG = "SoldierProperties";
    private SoldierPropertyMap soldierProperties;

    public ClaySoldierSnowball(EntityType<? extends Snowball> entityType, Level level) {
        super(entityType, level);
        this.soldierProperties = SoldierPropertyMap.EMPTY_MAP;
    }

    public ClaySoldierSnowball(Level pLevel, LivingEntity shooter, SoldierHoldableEffect holdableEffect) {
        super(ModEntityTypes.CLAY_SOLDIER_SNOWBALL.get(), pLevel);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setOwner((Entity)shooter);
        this.soldierProperties = holdableEffect.properties();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        SoldierPropertyMap.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.soldierProperties).ifSuccess(tag -> compound.put(PROPERTIES_TAG, tag)).ifError(err -> ClaySoldiersCommon.LOGGER.error("Error Saving Properties for Clay Soldier Snowball {}", (Object)this.soldierProperties));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(PROPERTIES_TAG)) {
            SoldierPropertyMap.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound).ifSuccess(s -> {
                this.soldierProperties = s;
            }).ifError(err -> ClaySoldiersCommon.LOGGER.error("Error reading Properties for Clay Soldier Snowball"));
        }
    }

    public void onHitEntity(EntityHitResult pResult) {
        Entity hitTarget = pResult.getEntity();
        Entity entity = this.getOwner();
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            float bonusDamage = 0.0f;
            for (SpecialAttack<?> specialAttack : this.soldierProperties.specialAttacks(SpecialAttackType.MELEE_AND_RANGED, SpecialEffectCategory.HARMFUL)) {
                specialAttack.performAttackEffect(soldier, hitTarget);
                bonusDamage += specialAttack.getBonusDamage(soldier, hitTarget);
            }
            hitTarget.hurt(this.damageSources().thrown((Entity)this, (Entity)soldier), this.soldierProperties.damage() + bonusDamage);
        }
    }
}

