/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.throwables;

import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierThrowableItemEntity
extends ThrowableItemProjectile {
    @Nullable
    private ItemStackWithEffect thrownItem;

    public ClaySoldierThrowableItemEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.thrownItem = null;
    }

    public ClaySoldierThrowableItemEntity(Level pLevel, LivingEntity shooter, @NotNull ItemStackWithEffect thrownItem) {
        super(ModEntityTypes.CLAY_SOLDIER_THROWABLE_ITEM.get(), shooter, pLevel);
        this.thrownItem = thrownItem;
    }

    @NotNull
    protected Item getDefaultItem() {
        if (this.thrownItem == null) {
            if (this.getEntityData() == null) {
                return Items.STRUCTURE_VOID;
            }
            if (this.getItem().isEmpty()) {
                return Items.BARRIER;
            }
            return this.getItem().getItem();
        }
        return this.thrownItem.stack().getItem();
    }

    public void setItem(ItemStack stack) {
        super.setItem(stack);
        if (this.thrownItem == null || this.thrownItem.is(stack.getItem())) {
            this.thrownItem = new ItemStackWithEffect(stack);
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity;
        Entity hitTarget = pResult.getEntity();
        if (this.thrownItem == null || this.thrownItem.effect() == null) {
            hitTarget.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            return;
        }
        SoldierHoldableEffect effect = this.thrownItem.effect();
        if (effect != null && (entity = this.getOwner()) instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            float bonusDamage = 0.0f;
            for (SpecialAttack<?> specialAttack : effect.getSpecialRangedAttacks()) {
                specialAttack.performAttackEffect(soldier, hitTarget);
                bonusDamage += specialAttack.getBonusDamage(soldier, hitTarget);
            }
            hitTarget.hurt(this.damageSources().thrown((Entity)this, (Entity)soldier), effect.damage() + bonusDamage);
            int secOnFireInTicks = effect.properties().setOnFire();
            if (secOnFireInTicks > 0) {
                hitTarget.igniteForTicks(secOnFireInTicks);
            }
        }
    }
}

