/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.cap.ClaySoldierItemHandler;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ModCapabilities {
    public static final BlockCapability<BlueprintRequestHandler, Void> BLUEPRINT_REQUEST_CAP = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"blueprint_request_handler"), BlueprintRequestHandler.class);
    public static final BlockCapability<AssignablePoiCapability, Void> ASSIGNABLE_POI_CAP = BlockCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"assignable_poi_cap"), AssignablePoiCapability.class);

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IEnergyStorage, Direction>(){

            @Nullable
            public IEnergyStorage getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, Direction context) {
                IHamsterWheelEnergyStorage en = HamsterWheelBlockEntity.getEnergyStorage(blockEntity, context);
                return en == null ? null : (IEnergyStorage)en;
            }
        }, new Block[]{ModBlocks.HAMSTER_WHEEL_BLOCK.get()});
        event.registerBlockEntity(BLUEPRINT_REQUEST_CAP, ModBlockEntities.EASEL_BLOCK_ENTITY.get(), (easel, unused) -> easel.getBlueprintRequestHandler());
        event.registerBlockEntity(ASSIGNABLE_POI_CAP, ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), (wheel, unused) -> wheel.getPoiCap());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), (soldier, context) -> new ClaySoldierItemHandler((ClaySoldierInventoryHandler)soldier));
    }
}

