/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.integration.ExternalMods;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public final class ModTags {

    public static final class PoiTypes {
        public static final TagKey<PoiType> SOLDIER_CONTAINER = PoiTypes.create("soldier_container");

        private static TagKey<PoiType> create(String name) {
            return TagKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
        }
    }

    public static final class SoldierPropertyTypes {
        public static final TagKey<SoldierPropertyType<?>> REQUIRES_OWNER = SoldierPropertyTypes.create("requires_owner");

        private static TagKey<SoldierPropertyType<?>> create(String name) {
            return TagKey.create(ModRegistries.SOLDIER_PROPERTY_TYPES, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
        }
    }

    public static final class Enchantments {
        public static final TagKey<Enchantment> SOLDIER_SLINGSHOT_EXCLUSIVE = Enchantments.create("clay_soldier_slingshot_exclusive");

        private static TagKey<Enchantment> create(String name) {
            return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
        }
    }

    public static final class EntityTypes {
        public static final TagKey<EntityType<?>> CLAY_BOSS = EntityTypes.create("clay_boss");

        private static TagKey<EntityType<?>> create(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
        }
    }

    public static final class DamageTypes {
        public static final TagKey<DamageType> CLAY_SOLDIER_DAMAGE = DamageTypes.create("clay_soldier_damage");

        private static TagKey<DamageType> create(String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
        }
    }

    public static final class Blocks {
        public static final TagKey<Block> BLUEPRINT_BLACK_LISTED = Blocks.create("blueprint_blacklisted");

        private static TagKey<Block> create(String location) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)location));
        }
    }

    public static final class Items {
        public static final TagKey<Item> SOLDIER_HOLDABLE = Items.create("clay_soldier_holdable");
        public static final TagKey<Item> SOLDIER_WEAPON = Items.create("clay_soldier_weapon");
        public static final TagKey<Item> SOLDIER_ARMOR = Items.create("clay_soldier_armor");
        public static final TagKey<Item> SOLDIER_BOSS_EQUIPABLE = Items.create("clay_boss_equiable");
        public static final TagKey<Item> BASIC = Items.create("clay_soldier_items/basic");
        public static final TagKey<Item> RANGED = Items.create("clay_soldier_items/ranged");
        public static final TagKey<Item> TANK = Items.create("clay_soldier_items/tank");
        public static final TagKey<Item> ARMORED = Items.create("clay_soldier_items/armored");
        public static final TagKey<Item> SPECIALIST = Items.create("clay_soldier_items/specialist");
        public static final TagKey<Item> HEALER = Items.create("clay_soldier_items/supportive");
        public static final TagKey<Item> EXPLOSIVE_EXPERT = Items.create("clay_soldier_items/explosive_export");
        public static final TagKey<Item> DIVER = Items.create("clay_soldier_items/diver");
        public static final TagKey<Item> ARSONIST = Items.create("clay_soldier_items/arsonist");
        public static final TagKey<Item> MAGICIAN = Items.create("clay_soldier_items/magician");
        public static final TagKey<Item> ROYALTY = Items.create("clay_soldier_items/royalty");
        public static final TagKey<Item> FASHION = Items.create("clay_soldier_items/fashion");
        public static final TagKey<Item> KINGDOM = Items.create("clay_soldier_items/kingdom");
        public static final TagKey<Item> CLAY_HORSE_ARMOR = Items.create("clay_horse_armor");
        public static final TagKey<Item> SOLDIER_RGB_GLASSES = Items.create("soldier_rgb_glasses");
        public static final TagKey<Item> CLAY_FOOD = Items.create("clay_food");
        public static final TagKey<Item> CLAY_WAX = Items.create("clay_wax");
        public static final TagKey<Item> SOLDIER_POI = Items.create("soldier_poi");
        public static final TagKey<Item> SOLDIER_SLINGSHOT_ENCHANTABLE = Items.create("enchantable/clay_soldier_slingshot");
        public static final TagKey<Item> DYES = Items.commonTag("dyes");
        public static final TagKey<Item> GLASS_PANES = Items.commonTag("glass_panes");
        public static final TagKey<Item> GLASS_PANES_COLORLESS = Items.commonTag("glass_panes/colorless");
        public static final TagKey<Item> GAME_MASTER_ITEM = Items.commonTag("game_master_items");
        public static final TagKey<Item> INGOTS_COPPER = Items.commonTag("ingots/copper");
        public static final TagKey<Item> WRENCH = Items.commonTag("tools/wrench");
        public static final TagKey<Item> ACCESSORIES_FACE = Items.create(ExternalMods.ACCESSORIES.getName(), "face");
        public static final TagKey<Item> CURIOS_HEAD = Items.create(ExternalMods.CURIOS.getName(), "head");

        private static TagKey<Item> create(String location) {
            return Items.create("csr", location);
        }

        private static TagKey<Item> commonTag(String name) {
            return Items.create("c", name);
        }

        private static TagKey<Item> create(String modId, String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
        }
    }
}

