/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.integration.NeoForgeAirBubbleElement;
import net.bumblebee.claysoldiers.integration.NeoForgeMultiLineTextElement;
import net.bumblebee.claysoldiers.integration.jade.CommonBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityServerAppender;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayMobProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.CompoundElement;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ItemStackElement;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        JadeRegistry.getBlocks().forEach(jadeBlock -> registration.registerBlockComponent((IComponentProvider)new NeoForgeBlockProvider((CommonBlockProvider)jadeBlock), jadeBlock.getTargetClass()));
        JadeRegistry.getEntities().forEach(jadeEntity -> {
            NeoForgeEntityProvider provider = new NeoForgeEntityProvider(jadeEntity);
            registration.registerEntityComponent(provider, jadeEntity.getTargetClass());
            if (jadeEntity == ClayMobProvider.INSTANCE) {
                registration.registerEntityIcon(provider, jadeEntity.getTargetClass());
            }
        });
    }

    public void register(IWailaCommonRegistration registration) {
        JadeRegistry.getServerEntities().forEach(jadeEntityServer -> registration.registerEntityDataProvider(new NeoForgeEntityDataProvider(jadeEntityServer), jadeEntityServer.getTargetClass()));
    }

    private record NeoForgeEntityDataProvider<T extends Entity>(CommonEntityServerAppender<T> serverAppender) implements IServerDataProvider<EntityAccessor>
    {
        public void appendServerData(CompoundTag compoundTag, EntityAccessor accessor) {
            this.serverAppender.appendServerData(compoundTag, accessor.getEntity());
        }

        public ResourceLocation getUid() {
            return this.serverAppender.getUniqueId();
        }
    }

    private record NeoForgeEntityProvider<T extends Entity>(CommonEntityProvider<T> provider) implements IEntityComponentProvider
    {
        public ResourceLocation getUid() {
            return this.provider.getUniqueId();
        }

        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            this.provider.appendTooltip(entityAccessor.getEntity(), new NeoForgeTooltipHelper(iTooltip), entityAccessor.showDetails(), this.provider.requiresServerData() ? entityAccessor.getServerData() : null);
        }

        @Nullable
        public IElement getIcon(EntityAccessor accessor, IPluginConfig config, IElement currentIcon) {
            if (this.provider != ClayMobProvider.INSTANCE) {
                return super.getIcon((Accessor)accessor, config, currentIcon);
            }
            if (accessor.getPickedResult().isEmpty()) {
                return currentIcon;
            }
            IElementHelper helper = IElementHelper.get();
            IElement largeIcon = helper.item(accessor.getPickedResult());
            if (((ClayMobEntity)accessor.getEntity()).isWaxed()) {
                return new CompoundElement(largeIcon, helper.item(Items.HONEYCOMB.getDefaultInstance(), 0.5f));
            }
            return largeIcon;
        }
    }

    private record NeoForgeBlockProvider(CommonBlockProvider provider) implements IBlockComponentProvider
    {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.provider.appendTooltip(new CommonBlockProvider.BlockData(blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), blockAccessor.getServerData()), new NeoForgeTooltipHelper(iTooltip), blockAccessor.showDetails());
        }

        public ResourceLocation getUid() {
            return this.provider.getUniqueId();
        }
    }

    private record NeoForgeTooltipHelper(ITooltip tooltip) implements CommonTooltipHelper
    {
        private static final HorizontalLineElement LINE_ELEMENT = new HorizontalLineElement();

        @Override
        public void add(Component component) {
            this.tooltip.add(component);
        }

        @Override
        public void append(Component component) {
            this.tooltip.append(component);
        }

        @Override
        public void addItemStack(ItemStack stack) {
            this.tooltip.add((IElement)ItemStackElement.of((ItemStack)stack));
        }

        @Override
        public void appendItemStack(ItemStack stack) {
            this.tooltip.append((IElement)ItemStackElement.of((ItemStack)stack));
        }

        @Override
        public void airBubbles(int breath, boolean bursting) {
            this.tooltip.add((IElement)new NeoForgeAirBubbleElement(breath, bursting));
        }

        @Override
        public void addCompoundItemStack(ItemStack large, ItemStack small) {
            this.tooltip.add((IElement)new CompoundElement((IElement)ItemStackElement.of((ItemStack)large), (IElement)ItemStackElement.of((ItemStack)small, (float)0.5f)));
        }

        @Override
        public void appendMultilineText(Component ... lines) {
            this.tooltip.append((IElement)new NeoForgeMultiLineTextElement(lines));
        }

        @Override
        public void addHorizontalLine() {
            this.tooltip.add((IElement)LINE_ELEMENT);
        }
    }
}

