/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.overlay.DisplayHelper;

public class NeoForgeMultiLineTextElement
extends Element {
    private final FormattedText[] lines;
    private final int maxWidth;
    private final String text;

    public NeoForgeMultiLineTextElement(Component[] line) {
        this.lines = line;
        if (line.length == 0) {
            throw new IllegalArgumentException("Cannot create a MultiLineElement with 0 lines");
        }
        Font font = Minecraft.getInstance().font;
        int maxWidth = 0;
        StringBuilder builder = new StringBuilder();
        for (FormattedText text : this.lines) {
            maxWidth = Math.max(maxWidth, font.width(text));
            builder.append(text.getString());
            builder.append(" ");
        }
        this.maxWidth = maxWidth;
        this.text = builder.toString();
    }

    public Vec2 getSize() {
        Font font = Minecraft.getInstance().font;
        float f = this.maxWidth;
        Objects.requireNonNull(font);
        return new Vec2(f, (float)((9 + 1) * this.lines.length - 1));
    }

    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        Font font = Minecraft.getInstance().font;
        for (int i = 0; i < this.lines.length; ++i) {
            FormattedText formattedText = this.lines[i];
            Objects.requireNonNull(font);
            DisplayHelper.INSTANCE.drawText(guiGraphics, formattedText, x, y + (float)((1 + 9) * i), IThemeHelper.get().getNormalColor());
        }
    }

    public String getMessage() {
        return this.text;
    }
}

