/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.accessories;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModAccessories {
    public static void init() {
        for (Accessories accessory : Accessories.values()) {
            AccessoriesAPI.registerAccessory((Item)accessory.item.get(), (Accessory)accessory);
        }
        ClaySoldiersCommon.IS_WEARING_GOGGLES = ClaySoldiersCommon.IS_WEARING_GOGGLES.or(p -> ModAccessories.hasAccessory((Entity)p, stack -> stack.is((Item)ModItems.CLAY_GOGGLES.get())));
    }

    public static boolean hasAccessory(Entity pEntity, Predicate<ItemStack> condition) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            return AccessoriesCapability.getOptionally((LivingEntity)livingEntity).map(c -> c.getFirstEquipped(condition)).isPresent();
        }
        return false;
    }

    private static enum Accessories implements Accessory
    {
        CLAY_GOGGLES(ModItems.CLAY_GOGGLES);

        private final Supplier<? extends Item> item;

        private Accessories(Supplier<? extends Item> item) {
            this.item = item;
        }
    }
}

