/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.integration.jade.providers.ClaySoldierProvider;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public enum BossClaySoldierProvider implements CommonEntityProvider<BossClaySoldierEntity>
{
    INSTANCE;

    public static final String CLAY_SOLDIER_BOSS_NAME;

    @Override
    public void appendTooltip(BossClaySoldierEntity entity, CommonTooltipHelper tooltip, boolean detail, CompoundTag serverData) {
        tooltip.add(this.createTeamName(entity));
        Component workStatus = entity.getWorkStatus();
        if (workStatus != null) {
            tooltip.add(workStatus);
        }
        if (ClaySoldiersCommon.PLATFORM.isDevEnv()) {
            tooltip.add((Component)Component.translatable((String)ClaySoldierProvider.SOLDIER_PROPERTIES).append(":").withStyle(ChatFormatting.DARK_GRAY));
            ArrayList<Component> components = new ArrayList<Component>();
            ComponentFormating.formatProperties(components, entity.allProperties(), List.of(SoldierPropertyTypes.PROTECTION.get(), SoldierPropertyTypes.ATTACK_TYPE.get(), SoldierPropertyTypes.SIZE.get(), (SoldierPropertyType)SoldierPropertyTypes.CAN_SWIM.get(), (SoldierPropertyType)SoldierPropertyTypes.SEE_INVISIBILITY.get()), entity);
            components.forEach(tooltip::add);
        }
    }

    private Component createTeamName(BossClaySoldierEntity clayMob) {
        return Component.translatable((String)CLAY_SOLDIER_BOSS_NAME).withColor(clayMob.getClayTeam().getColor((LivingEntity)clayMob, 0.0f));
    }

    @Override
    public ResourceLocation getUniqueId() {
        return JadeRegistry.BOSS_CLAY_SOLDIER;
    }

    @Override
    public Class<BossClaySoldierEntity> getTargetClass() {
        return BossClaySoldierEntity.class;
    }

    static {
        CLAY_SOLDIER_BOSS_NAME = JadeRegistry.getLangKey(INSTANCE, "boss_name");
    }
}

