/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import java.util.function.BiConsumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public enum ClayMobProvider implements CommonEntityProvider<ClayMobEntity>
{
    INSTANCE;

    public static final String CLAY_MOB_TEAM;

    @Override
    public void appendTooltip(ClayMobEntity entity, CommonTooltipHelper tooltip, boolean detail, CompoundTag tag) {
        if (entity.getType().is(ModTags.EntityTypes.CLAY_BOSS)) {
            return;
        }
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            ClayMobProvider.addAirBubbles(soldier, tooltip::airBubbles);
        }
        tooltip.add(this.createTeamName(entity));
        Component workStatus = entity.getWorkStatus();
        if (workStatus != null) {
            tooltip.add(workStatus);
        }
    }

    @Override
    public ResourceLocation getUniqueId() {
        return JadeRegistry.CLAY_MOB;
    }

    @Override
    public Class<ClayMobEntity> getTargetClass() {
        return ClayMobEntity.class;
    }

    public Component createTeamName(ClayMobEntity clayMob) {
        return Component.translatable((String)CLAY_MOB_TEAM).withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append(clayMob.getClayTeam().getDisplayNameWithColor(c -> c.getColor((LivingEntity)clayMob, 0.0f)));
    }

    private static void addAirBubbles(AbstractClaySoldierEntity soldier, BiConsumer<Integer, Boolean> adder) {
        if (!soldier.isInWater() || soldier.allProperties().breathHoldDuration() >= 1000) {
            return;
        }
        int breathPercent = (int)((float)(soldier.getAirSupply() * 10) / (float)soldier.getMaxAirSupply());
        int breathPercentAfter = (int)((float)((soldier.getAirSupply() - 1) * 10) / (float)soldier.getMaxAirSupply());
        adder.accept(breathPercent, breathPercent > breathPercentAfter);
    }

    static {
        CLAY_MOB_TEAM = JadeRegistry.getLangKey(INSTANCE, "team");
    }
}

