/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.VampireClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public enum ClaySoldierProvider implements CommonEntityProvider<AbstractClaySoldierEntity>
{
    INSTANCE;

    public static final String SOLDIER_PROPERTIES;
    public static final String ALPHA_PREFIX;
    public static final String OFFSET_COLOR;

    @Override
    public void appendTooltip(AbstractClaySoldierEntity claySoldier, CommonTooltipHelper tooltip, boolean detail, CompoundTag tag) {
        if (claySoldier.getType().is(ModTags.EntityTypes.CLAY_BOSS)) {
            return;
        }
        ClaySoldierProvider.formatAttackTypeProperty(tooltip, claySoldier.getAttackType(), claySoldier);
        ClaySoldierProvider.formatOffsetColor(tooltip, claySoldier);
        if (detail) {
            tooltip.add((Component)Component.translatable((String)SOLDIER_PROPERTIES).append(":").withStyle(ChatFormatting.DARK_GRAY));
            ArrayList<Component> components = new ArrayList<Component>();
            ComponentFormating.formatProperties(components, claySoldier.allProperties(), List.of(SoldierPropertyTypes.PROTECTION.get(), SoldierPropertyTypes.ATTACK_TYPE.get()), claySoldier);
            components.forEach(tooltip::add);
        }
    }

    private static void formatAttackTypeProperty(CommonTooltipHelper tooltip, AttackTypeProperty property, AbstractClaySoldierEntity claySoldier) {
        Component name = property.getAnimatedDisplayName((LivingEntity)claySoldier);
        if (name != null) {
            VampireClaySoldierEntity vampireClaySoldier;
            if (claySoldier instanceof VampireClaySoldierEntity && (vampireClaySoldier = (VampireClaySoldierEntity)claySoldier).isAlpha()) {
                tooltip.add((Component)Component.translatable((String)ALPHA_PREFIX).withStyle(AttackTypeProperty.VAMPIRE.getAnimatedStyle((LivingEntity)claySoldier)));
                tooltip.append(CommonComponents.SPACE);
                tooltip.append(name);
            } else {
                tooltip.add(name);
            }
        }
    }

    private static void formatOffsetColor(CommonTooltipHelper tooltip, AbstractClaySoldierEntity soldier) {
        if (soldier.hasOffsetColor()) {
            tooltip.add(CommonComponents.SPACE);
            tooltip.append((Component)Component.translatable((String)OFFSET_COLOR).append(": "));
            ColorHelper color = soldier.getOffsetColor();
            tooltip.append(color.formatDynamic((LivingEntity)soldier));
        }
    }

    @Override
    public ResourceLocation getUniqueId() {
        return JadeRegistry.CLAY_SOLDIER;
    }

    @Override
    public Class<AbstractClaySoldierEntity> getTargetClass() {
        return AbstractClaySoldierEntity.class;
    }

    static {
        SOLDIER_PROPERTIES = JadeRegistry.getLangKey(INSTANCE, "soldier_properties");
        ALPHA_PREFIX = JadeRegistry.getLangKey(INSTANCE, "alpha_prefix");
        OFFSET_COLOR = JadeRegistry.getLangKey(INSTANCE, "offset_color");
    }
}

