/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.List;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public final class ClaySoldierCookingRecipe {
    private static final String GROUP = "jei.csr.soldier.cooking";
    private static final String ID = "jei.csr.soldier.%s.%s";

    public static <T extends AbstractCookingRecipe> List<RecipeHolder<T>> createCookingRecipe(CookingRecipeBuilder<T> factory, int smeltingTime) {
        ItemStack output = ModItems.BRICKED_CLAY_SOLDIER.get().getDefaultInstance();
        Ingredient input = Ingredient.of(ClayMobTeamManger.getAllKeys((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).map(team -> ClayMobTeamManger.createStackForTeam(team, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        T cookingRecipe = factory.build(GROUP, CookingBookCategory.MISC, input, output, 1.0f, smeltingTime);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)ID.formatted(cookingRecipe.category().getSerializedName(), output.getDescriptionId()));
        return List.of(new RecipeHolder(id, cookingRecipe));
    }

    private ClaySoldierCookingRecipe() {
    }

    @FunctionalInterface
    public static interface CookingRecipeBuilder<T extends AbstractCookingRecipe> {
        public T build(String var1, CookingBookCategory var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

