/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.List;
import java.util.Objects;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierCrafting {
    private static final String CLAY_SOLDIER_REVIVING = "jei.csr.soldier.revive";
    private static final String CLAY_SOLDIER_CRAFTING = "jei.csr.soldier.crafting";

    public static List<RecipeHolder<CraftingRecipe>> createRecipes() {
        return ClayMobTeamManger.getAllKeys((HolderLookup.Provider)ClaySoldierCrafting.getRegistries()).mapMulti((entry, r) -> {
            for (int i = 1; i <= 8; ++i) {
                r.accept(ClaySoldierCrafting.createRecipe(entry, i));
            }
        }).filter(Objects::nonNull).toList();
    }

    @Nullable
    private static RecipeHolder<CraftingRecipe> createRecipe(ResourceLocation entry, int count) {
        Item getFrom = ClayMobTeamManger.getFromKeyOrError(entry, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).getGetFrom();
        if (getFrom == null) {
            return null;
        }
        NonNullList inputs = NonNullList.createWithCapacity((int)(count + 1));
        inputs.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{getFrom}));
        for (int i = 0; i < count; ++i) {
            inputs.add((Object)Ingredient.of(ClayMobTeamManger.getAllKeys((HolderLookup.Provider)ClaySoldierCrafting.getRegistries()).map(team -> ClayMobTeamManger.createStackForTeam(team, (HolderLookup.Provider)ClaySoldierCrafting.getRegistries()))));
        }
        ItemStack output = ClayMobTeamManger.createStackForTeam(entry, (HolderLookup.Provider)ClaySoldierCrafting.getRegistries());
        output.setCount(count);
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)("jei.csr.soldier.crafting." + output.getDescriptionId() + "_" + count));
        ShapelessRecipe recipe = new ShapelessRecipe(CLAY_SOLDIER_CRAFTING, CraftingBookCategory.MISC, output, inputs);
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }

    public static List<RecipeHolder<CraftingRecipe>> createClaySoldierRevive() {
        return ClayMobTeamManger.getAllKeys((HolderLookup.Provider)ClaySoldierCrafting.getRegistries()).map(ClaySoldierCrafting::createClaySoldierRevive).toList();
    }

    public static RecipeHolder<CraftingRecipe> createClaySoldierRevive(ResourceLocation team) {
        ItemStack output = ClayMobTeamManger.createStackForTeam(team, (HolderLookup.Provider)ClaySoldierCrafting.getRegistries());
        ItemStack input = ModItems.BRICKED_CLAY_SOLDIER.get().getDefaultInstance();
        input.set(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)team);
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)("jei.csr.soldier.revive." + output.getDescriptionId()));
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{input}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})});
        ShapelessRecipe recipe = new ShapelessRecipe(CLAY_SOLDIER_REVIVING, CraftingBookCategory.MISC, output, inputs);
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }

    private static RegistryAccess getRegistries() {
        return Minecraft.getInstance().level.registryAccess();
    }
}

