/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.init.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public final class ShearBladeRecipe {
    private static final String SHEAR_BLADE_CRAFTING = "jei.csr.shear_blade";

    public static List<RecipeHolder<CraftingRecipe>> createShearBladeRecipe() {
        ItemStack output = ModItems.SHEAR_BLADE.get().getDefaultInstance();
        ItemStack input1 = Items.SHEARS.getDefaultInstance();
        ArrayList<ItemStack> inp = new ArrayList<ItemStack>();
        inp.add(input1);
        int maxDamage = input1.getMaxDamage();
        for (int i = 1; i < maxDamage / 2; i += 20) {
            ItemStack inputDamaged = Items.SHEARS.getDefaultInstance();
            inputDamaged.setDamageValue(i);
            inp.add(inputDamaged);
        }
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of(inp.stream())});
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)SHEAR_BLADE_CRAFTING);
        ShapelessRecipe recipe = new ShapelessRecipe(SHEAR_BLADE_CRAFTING, CraftingBookCategory.MISC, output, inputs);
        return List.of(new RecipeHolder(recipeId, (Recipe)recipe));
    }

    private ShearBladeRecipe() {
    }
}

