/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claymobspawn;

import java.util.List;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.soldier.AdditionalSoldierData;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.BrickedItemHolder;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ClaySoldierSpawnItem
extends MultiSpawnItem<ClaySoldierEntity>
implements BrickedItemHolder {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"item/clay_soldier");
    public static final String DESCRIPTION_ID_PREFIX = ".with_prefix";
    public static final String PLAYER_LANG = "item.csr.clay_soldier.player";

    public ClaySoldierSpawnItem(Item.Properties props) {
        super(props.component(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)ClayMobTeamManger.DEFAULT_TYPE));
    }

    @Override
    public EntityType<ClaySoldierEntity> getType() {
        return ModEntityTypes.CLAY_SOLDIER_ENTITY.get();
    }

    @Override
    public ItemStack getBrickedItem(ItemStack original) {
        return original.transmuteCopy((ItemLike)ModItems.BRICKED_CLAY_SOLDIER.get());
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        ClayMobTeam team;
        List<String> list;
        ResourceLocation teamKey = (ResourceLocation)pStack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        if (pTooltipFlag.isAdvanced()) {
            AdditionalSoldierData type;
            if (teamKey != null) {
                pTooltipComponents.add((Component)CommonComponents.space().append(teamKey.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            if ((type = (AdditionalSoldierData)pStack.get(ModDataComponents.CLAY_SOLDIER_ADDITIONAL_DATA.get())) != null) {
                pTooltipComponents.add((Component)CommonComponents.space().append(type.displayName()).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (!(list = (team = ClayMobTeamManger.getFromKeyOrError(teamKey, pContext.registries())).getPlayerNames()).isEmpty()) {
            if (list.size() == 1) {
                pTooltipComponents.add((Component)CommonComponents.space().append((Component)Component.translatable((String)PLAYER_LANG, (Object[])new Object[]{list.getFirst()})).withStyle(ChatFormatting.DARK_GRAY));
            } else {
                pTooltipComponents.add((Component)CommonComponents.space().append((Component)Component.translatable((String)PLAYER_LANG, (Object[])new Object[]{list.toString()})).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    public Consumer<ClaySoldierEntity> modifyBeforeSpawn(ItemStack stack) {
        return claySoldier -> {
            claySoldier.setClayTeamType((ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()));
            claySoldier.setSpawnedFrom(stack, true);
            AdditionalSoldierData additionalSoldierData = (AdditionalSoldierData)stack.get(ModDataComponents.CLAY_SOLDIER_ADDITIONAL_DATA.get());
            if (additionalSoldierData != null) {
                additionalSoldierData.convert(claySoldier);
            }
        };
    }

    public static void setClayMobTeam(ItemStack stack, ResourceLocation teamId, HolderLookup.Provider registries) {
        ClayMobTeam team = ClayMobTeamManger.getFromKeyOrError(teamId, registries);
        stack.set(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)teamId);
        if (!ClayMobTeamManger.DEFAULT_TYPE.equals((Object)teamId)) {
            stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)(ModItems.CLAY_SOLDIER.get().getDescriptionId() + DESCRIPTION_ID_PREFIX), (Object[])new Object[]{team.getDisplayName()}));
        }
    }

    @Override
    protected boolean isValid(ItemStack stack, Level level, Player player) {
        ResourceLocation key = (ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        if (key == null) {
            return false;
        }
        ClayMobTeam team = ClayMobTeamManger.getFromKey(key, level.registryAccess());
        if (team == null) {
            return false;
        }
        return team.canBeUsed(player);
    }

    @Override
    public int getPouchColor(DataComponentMap stack, LivingEntity viewing) {
        return ClaySoldierSpawnItem.getColorFromTeam((ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), viewing);
    }

    @Override
    public DataComponentMap requiredForPouch(ItemStack stack) {
        ResourceLocation team = (ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        DataComponentMap.Builder builder = DataComponentMap.builder().set(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)team);
        return builder.build();
    }

    @Override
    public ItemStack recreateStackFromPouch(DataComponentMap data, HolderLookup.Provider registries) {
        ItemStack stack = new ItemStack((ItemLike)this);
        ClaySoldierSpawnItem.setClayMobTeam(stack, (ResourceLocation)data.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), registries);
        return stack;
    }

    public static int getColorFromTeam(ResourceLocation team, LivingEntity player) {
        int color = ClayMobTeamManger.getFromKeyOrError(team, (HolderLookup.Provider)player.registryAccess()).getColor(player, 0.0f);
        if (color == -1) {
            return -6182991;
        }
        return FastColor.ARGB32.opaque((int)color);
    }
}

