/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claymobspawn;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.variant.NameableVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiSpawnItem<T extends Entity>
extends Item {
    public MultiSpawnItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static <V extends NameableVariant, T extends ClayMobEntity> MultiSpawnItem<T> createClayMob(final Supplier<EntityType<T>> entityType, final V variant, Item.Properties properties) {
        return new MultiSpawnItem<T>(properties){

            @Override
            public EntityType<T> getType() {
                return (EntityType)entityType.get();
            }

            @Override
            public Consumer<T> modifyBeforeSpawn(ItemStack stack) {
                return clayMob -> {
                    clayMob.setSpawnedFrom(stack, true);
                    ((VariantHolder)clayMob).setVariant((Object)variant);
                };
            }

            @Override
            public int getPouchColor(DataComponentMap data, LivingEntity viewing) {
                return variant.getPouchColor();
            }
        };
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        int res;
        Player player = pContext.getPlayer();
        int stackCount = pContext.getItemInHand().getCount();
        if (player != null && player.isShiftKeyDown()) {
            stackCount = 1;
        }
        if ((res = this.spawnWithCount(pContext.getItemInHand(), pContext, stackCount)) > 0) {
            pContext.getItemInHand().shrink(res);
            return InteractionResult.CONSUME;
        }
        return res == -1 ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    public int spawnWithCount(ItemStack doll, UseOnContext pContext, int count) {
        if (!this.isValid(doll, pContext.getLevel(), pContext.getPlayer()) || count <= 0) {
            return -1;
        }
        Level level = pContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockEntity blockEntity = level.getBlockEntity(blockpos);
        if (blockEntity instanceof Spawner) {
            Spawner spawner = (Spawner)blockEntity;
            spawner.setEntityId(this.getType(), level.getRandom());
            level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockpos);
            return 1;
        }
        BlockPos updatedBlockPos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType<T> entitytype = this.getType();
        for (int i = 0; i < count; ++i) {
            if (entitytype.spawn((ServerLevel)level, this.modifyBeforeSpawn(doll.copyWithCount(1)), updatedBlockPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, updatedBlockPos) && direction == Direction.UP) == null) continue;
            level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        return count;
    }

    protected boolean isValid(ItemStack stack, Level level, @Nullable Player player) {
        return true;
    }

    public abstract EntityType<T> getType();

    public abstract Consumer<T> modifyBeforeSpawn(ItemStack var1);

    public DataComponentMap requiredForPouch(ItemStack stack) {
        return DataComponentMap.EMPTY;
    }

    public abstract int getPouchColor(DataComponentMap var1, LivingEntity var2);

    public ItemStack recreateStackFromPouch(DataComponentMap data, HolderLookup.Provider registries) {
        return this.getDefaultInstance();
    }
}

