/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claypouch;

import java.util.List;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.bumblebee.claysoldiers.item.claypouch.ClayPouchContent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.context.UseOnContext;

public class ClayPouchItem
extends Item {
    public static final String FULLNESS_LANG = "item.csr.clay_pouch.fullness";
    private static final int BAR_COLOR = -6182991;

    public ClayPouchItem(Item.Properties properties) {
        super(properties);
    }

    public boolean overrideStackedOnOther(ItemStack pouch, Slot slot, ClickAction action, Player player) {
        ClayPouchContent newContent;
        int used;
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack toAbsorb = slot.getItem();
        if (toAbsorb.isEmpty()) {
            if (ClayPouchContent.onPouch(pouch, c -> c.takeStack(arg_0 -> ((Slot)slot).safeInsert(arg_0), (HolderLookup.Provider)player.registryAccess()))) {
                this.playRemoveOneSound((Entity)player);
                return true;
            }
            return false;
        }
        Item item = toAbsorb.getItem();
        if (!(item instanceof MultiSpawnItem)) {
            return false;
        }
        MultiSpawnItem multi = (MultiSpawnItem)item;
        ClayPouchContent content = (ClayPouchContent)pouch.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content != null && !content.isFor(toAbsorb)) {
            return false;
        }
        if (content == null) {
            used = Math.min(toAbsorb.getCount(), 256);
            newContent = new ClayPouchContent(multi, used, multi.requiredForPouch(toAbsorb));
        } else {
            used = Math.min(toAbsorb.getCount(), content.maxRemaining());
            newContent = content.increment(used);
        }
        this.playInsertSound((Entity)player);
        slot.remove(used);
        pouch.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)newContent);
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack pouch, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            ClayPouchContent content = (ClayPouchContent)pouch.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
            if (content == null) {
                Item item = other.getItem();
                if (item instanceof MultiSpawnItem) {
                    MultiSpawnItem multi = (MultiSpawnItem)item;
                    int used = Math.min(other.getCount(), 256);
                    pouch.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)new ClayPouchContent(multi, used, multi.requiredForPouch(other)));
                    other.shrink(used);
                    return true;
                }
                return false;
            }
            if (other.isEmpty()) {
                pouch.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)content.takeStack(arg_0 -> ((SlotAccess)access).set(arg_0), (HolderLookup.Provider)player.registryAccess()));
                this.playRemoveOneSound((Entity)player);
            } else {
                content.insert(other, (c, i) -> {
                    other.shrink(i.intValue());
                    pouch.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), c);
                    this.playInsertSound((Entity)player);
                });
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ClayPouchContent content = (ClayPouchContent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content != null && tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)Component.translatable((String)FULLNESS_LANG, (Object[])new Object[]{content.getCount(), 256}).withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((TooltipComponent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get())) : Optional.empty();
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.has(ModDataComponents.CLAY_POUCH_CONTENT.get());
    }

    public int getBarColor(ItemStack stack) {
        ClayPouchContent content = (ClayPouchContent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content == null || ClaySoldiersCommon.clientPlayer == null || ClaySoldiersCommon.clientPlayer.get() == null) {
            return -6182991;
        }
        return content.getColor((LivingEntity)ClaySoldiersCommon.clientPlayer.get());
    }

    public int getBarWidth(ItemStack stack) {
        ClayPouchContent content = (ClayPouchContent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        return content == null ? 0 : content.getFillPercent();
    }

    public void onDestroyed(ItemEntity itemEntity) {
        ClayPouchContent content = (ClayPouchContent)itemEntity.getItem().get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content != null) {
            itemEntity.getItem().set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, content.copyItems());
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemInHand = context.getItemInHand();
        ClayPouchContent content = (ClayPouchContent)itemInHand.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content == null) {
            return super.useOn(context);
        }
        MultiSpawnItem<?> multi = content.getItem();
        ItemStack doll = new ItemStack(multi);
        content.dataComponents().ifPresent(arg_0 -> ((ItemStack)doll).applyComponents(arg_0));
        Player player = context.getPlayer();
        int toSpawn = player != null && player.isCrouching() ? 1 : content.getCount();
        int res = multi.spawnWithCount(doll, context, toSpawn);
        if (res < 0) {
            return InteractionResult.FAIL;
        }
        itemInHand.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)content.shrink(res));
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

