/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claystaff;

import java.util.function.Predicate;
import net.bumblebee.claysoldiers.entity.boss.ClayBlockProjectileEntity;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.claypouch.ClayPouchContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClayStaffItem
extends Item {
    private static final int MIN_BLOCK_SIZE = 1;
    private static final int MAX_BLOCK_SIZE = 5;
    private static final Predicate<ItemStack> PROJECTILE_PREDICATE = stack -> stack.is(Items.CLAY_BALL);
    public static final Predicate<ItemStack> SOLDIER_PREDICATE = stack -> {
        if (ModItems.CLAY_SOLDIER.is((ItemStack)stack)) {
            return true;
        }
        ClayPouchContent pouchContent = (ClayPouchContent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        return pouchContent != null && pouchContent.getItem() == ModItems.CLAY_SOLDIER.get() && pouchContent.getCount() > 0;
    };
    public static final int MAX_HOLD_DURATION = 72000;

    public ClayStaffItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeRemaining) {
        Player player;
        block8: {
            block7: {
                if (!(livingEntity instanceof Player)) break block7;
                player = (Player)livingEntity;
                if (!level.isClientSide) break block8;
            }
            return;
        }
        boolean infiniteMaterials = livingEntity.hasInfiniteMaterials();
        ItemStack ammo = null;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack ammoSlot = player.getInventory().getItem(i);
            Predicate<ItemStack> ammoPredicate = ClayStaffItem.getAmmoPredicate(stack, level.registryAccess());
            if (!ammoPredicate.test(ammoSlot)) continue;
            ClayPouchContent content = (ClayPouchContent)ammoSlot.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
            ammo = content != null ? content.createStack((HolderLookup.Provider)level.registryAccess()) : ammoSlot;
            if (infiniteMaterials) break;
            if (content == null) {
                player.getInventory().removeItem(i, 1);
                break;
            }
            ammoSlot.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)content.shrink(1));
            break;
        }
        if (ammo == null && infiniteMaterials) {
            ItemStack itemStack = ammo = ClayStaffItem.getEnchantmentLevel(stack, ModEnchantments.SOLDIER_PROJECTILE, level.registryAccess()) > 0 ? ModItems.CLAY_SOLDIER.get().getDefaultInstance() : Items.CLAY_BALL.getDefaultInstance();
        }
        if (ammo != null) {
            this.shootBlock(livingEntity, level, stack, timeRemaining, (ResourceLocation)ammo.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()));
        }
    }

    public static ItemStack getClayStaffAmmo(Predicate<ItemStack> ammoPredicate, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack ammoSlot = player.getInventory().getItem(i);
            if (!ammoPredicate.test(ammoSlot)) continue;
            ClayPouchContent content = (ClayPouchContent)ammoSlot.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
            ItemStack ammo = content != null ? content.createStack((HolderLookup.Provider)player.registryAccess()) : ammoSlot;
            return ammo;
        }
        return null;
    }

    protected void shootBlock(LivingEntity shooter, Level level, ItemStack stack, int timeRemaining, @Nullable ResourceLocation clayTeam) {
        int pierce = ClayStaffItem.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.PIERCING, level.registryAccess());
        float blockSize = (float)(72000 - timeRemaining) * 3.0f / (float)ClayStaffItem.getMaxPower(stack, level.registryAccess());
        blockSize = Mth.clamp((float)(blockSize + 1.0f), (float)1.0f, (float)5.0f);
        this.shootBlock(shooter, level, blockSize, 0.0f, pierce, clayTeam);
        if (ClayStaffItem.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.MULTISHOT, level.registryAccess()) > 0) {
            this.shootBlock(shooter, level, blockSize, -15.0f, pierce, clayTeam);
            this.shootBlock(shooter, level, blockSize, 15.0f, pierce, clayTeam);
        }
    }

    protected void shootBlock(LivingEntity shooter, Level level, float blockSize, float yAngleOffset, int pierce, @Nullable ResourceLocation clayTeam) {
        ClayBlockProjectileEntity clayBlock = new ClayBlockProjectileEntity(level, shooter, shooter.getEyeHeight());
        clayBlock.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + yAngleOffset, 0.0f, blockSize / 2.0f, 1.0f);
        if (clayTeam != null) {
            clayBlock.setClayTeam(clayTeam);
        } else {
            clayBlock.setBlockSize(blockSize);
        }
        clayBlock.setPierceCount(pierce);
        level.addFreshEntity((Entity)clayBlock);
    }

    public static int getMaxPower(ItemStack stack, RegistryAccess registryAccess) {
        return switch (ClayStaffItem.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.QUICK_CHARGE, registryAccess)) {
            case 0 -> 40;
            case 1 -> 30;
            case 2 -> 20;
            default -> 10;
        };
    }

    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> key, RegistryAccess registries) {
        return registries.registry(Registries.ENCHANTMENT).map(r -> r.getHolder(key).map(h -> stack.getEnchantments().getLevel((Holder)h)).orElse(0)).orElse(0);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemInHand = player.getItemInHand(usedHand);
        Predicate<ItemStack> ammoPredicate = ClayStaffItem.getAmmoPredicate(itemInHand, player.registryAccess());
        if (player.hasInfiniteMaterials() || player.getInventory().contains(ammoPredicate)) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)itemInHand);
        }
        return InteractionResultHolder.fail((Object)itemInHand);
    }

    private static Predicate<ItemStack> getAmmoPredicate(ItemStack stack, RegistryAccess registries) {
        return ClayStaffItem.getEnchantmentLevel(stack, ModEnchantments.SOLDIER_PROJECTILE, registries) > 0 ? SOLDIER_PREDICATE : PROJECTILE_PREDICATE;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }
}

