/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claystaff;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.item.claystaff.ClayStaffItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ClayStaffModel
extends Model {
    private static final float DEG_2 = (float)Math.PI / 90;
    private static final float DEG_22 = 0.7853982f;
    private static final float CUBE_Y = -5.5f;
    private static final float SOLDIER_Y = -3.0f;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_staff"), "main");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/item/clay_staff.png");
    public static final ModelLayerLocation SOLDIER_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_staff_soldier"), "main");
    public static final ResourceLocation SOLDIER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/clay.png");
    private static final RenderType DOLL_RENDER_TYPE = RenderType.entityCutout((ResourceLocation)SOLDIER_TEXTURE);
    private final ModelPart root;
    private final ModelPart cube;
    private final ModelPart doll;

    public ClayStaffModel(ModelPart root, ModelPart doll) {
        super(RenderType::entitySolid);
        this.root = root;
        this.cube = root.getChild("cube");
        this.doll = doll;
    }

    public static ClayStaffModel create(Function<ModelLayerLocation, ModelPart> bakery) {
        return new ClayStaffModel(bakery.apply(LAYER_LOCATION), bakery.apply(SOLDIER_LAYER_LOCATION));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setCubeRotation(float radian) {
        this.cube.xRot = radian;
    }

    public void hideCube(boolean hide) {
        this.cube.visible = !hide;
    }

    public void scale(float percent, boolean scaleDoll) {
        if (scaleDoll) {
            this.doll.xScale = percent *= 0.5f;
            this.doll.yScale = percent;
            this.doll.zScale = percent;
            this.doll.y = -1.5f - percent * 1.5f;
        } else {
            this.cube.xScale = percent;
            this.cube.yScale = percent;
            this.cube.zScale = percent;
            this.cube.y = -2.5f - percent * 3.0f;
        }
    }

    public static void renderAsItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean doll;
        if (ClaySoldiersClient.clayStaffModel == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        boolean bl = doll = ClayStaffItem.getEnchantmentLevel(pStack, ModEnchantments.SOLDIER_PROJECTILE, Minecraft.getInstance().level.registryAccess()) > 0;
        if (pDisplayContext.firstPerson() || pDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || pDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            float scale = (float)Minecraft.getInstance().player.getTicksUsingItem() / (float)ClayStaffItem.getMaxPower(pStack, Minecraft.getInstance().level.registryAccess());
            ClaySoldiersClient.clayStaffModel.hideCube(doll);
            ClaySoldiersClient.clayStaffModel.scale(Math.min(scale, 1.0f), doll);
            if (doll) {
                ClaySoldiersClient.clayStaffModel.renderDoll(poseStack, buffer, packedLight, packedOverlay);
            } else {
                ClaySoldiersClient.clayStaffModel.setCubeRotation(((float)Minecraft.getInstance().level.getGameTime() + ClayStaffModel.getPartialTick()) % 360.0f * ((float)Math.PI / 90));
            }
        } else {
            ClaySoldiersClient.clayStaffModel.hideCube(true);
        }
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)ClaySoldiersClient.clayStaffModel.renderType(TEXTURE), (boolean)false, (boolean)pStack.hasFoil());
        ClaySoldiersClient.clayStaffModel.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void renderDoll(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ClayMobTeam team;
        ItemStack ammo = ClayStaffItem.getClayStaffAmmo(ClayStaffItem.SOLDIER_PREDICATE, (Player)Minecraft.getInstance().player);
        int color = -1;
        if (ammo != null && (team = ClayMobTeamManger.getFromKey((ResourceLocation)ammo.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), Minecraft.getInstance().level.registryAccess())) != null) {
            color = team.getColor((LivingEntity)Minecraft.getInstance().player, ClayStaffModel.getPartialTick());
        }
        this.doll.render(poseStack, buffer.getBuffer(DOLL_RENDER_TYPE), packedLight, packedOverlay, color);
    }

    public static LayerDefinition createStaffLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition staff = partdefinition.addOrReplaceChild("staff", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 2.0f, -0.5f, 1.0f, 21.0f, 1.0f), PartPose.ZERO);
        staff.addOrReplaceChild("wing", CubeListBuilder.create().texOffs(12, 6).addBox(-1.5f, -1.0f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.ZERO);
        staff.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(8, 6).addBox(-1.0f, -9.0f, -1.001f, 1.0f, 9.0f, 1.0f), PartPose.offsetAndRotation((float)0.5f, (float)3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        staff.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(4, 6).addBox(0.0f, -9.0f, -1.002f, 1.0f, 9.0f, 1.0f), PartPose.offsetAndRotation((float)-0.5f, (float)3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.4451f));
        PartDefinition cube = partdefinition.addOrReplaceChild("cube", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.5f, (float)0.0f));
        PartDefinition wrapper = cube.addOrReplaceChild("wrapper", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        wrapper.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(4, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createSoldierDollLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition doll = partdefinition.addOrReplaceChild("soldier", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        doll.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(8, 7).addBox(-0.5f, -1.5f, -1.0f, 1.0f, 3.0f, 2.0f), PartPose.ZERO);
        doll.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -4.5f, -2.0f, 1.0f, 3.0f, 4.0f), PartPose.ZERO);
        doll.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, -6.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    private static float getPartialTick() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
    }
}

