/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.itemeffectholder;

import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStackEffectHolder<P> {
    protected final ItemStack stack;
    @Nullable
    protected final P effect;

    public ItemStackEffectHolder(ItemStack stack, @Nullable P effect) {
        this.stack = stack;
        this.effect = effect;
    }

    public ItemStackEffectHolder(ItemStack stack) {
        this.stack = stack;
        this.effect = this.createEffectOnInitialisation(stack);
    }

    protected abstract P createEffectOnInitialisation(ItemStack var1);

    public P effect() {
        return this.effect;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public boolean is(Item item) {
        return this.stack.is(item);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int shrink(int count) {
        this.stack.shrink(count);
        return this.stack.getCount();
    }

    public int getCount() {
        return this.stack.getCount();
    }

    public void setCount(int count) {
        this.stack.setCount(count);
    }

    public Tag save(HolderLookup.Provider provider) {
        return this.stack.save(provider);
    }

    public static <S extends ItemStackEffectHolder<?>> S parseOptional(Function<ItemStack, S> builder, HolderLookup.Provider provider, CompoundTag pCompoundTag) {
        return (S)((ItemStackEffectHolder)builder.apply(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)pCompoundTag)));
    }

    public static <T> boolean matches(ItemStackEffectHolder<T> stack, ItemStackEffectHolder<T> other) {
        return ItemStack.matches((ItemStack)stack.stack, (ItemStack)other.stack);
    }
}

