/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu.soldier;

import java.util.Optional;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.bumblebee.claysoldiers.menu.AbstractClayMobMenu;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierMenu
extends AbstractClayMobMenu<AbstractClaySoldierEntity> {
    @Nullable
    private final AbstractClaySoldierEntity soldier;

    public ClaySoldierMenu(int pContainerId, Inventory inv, int extraData) {
        AbstractClaySoldierEntity claySoldier;
        Entity entity = inv.player.level().getEntity(extraData);
        this(pContainerId, inv, entity instanceof AbstractClaySoldierEntity ? (claySoldier = (AbstractClaySoldierEntity)entity) : null);
    }

    public ClaySoldierMenu(int pContainerId, Inventory inv, @Nullable AbstractClaySoldierEntity claySoldier) {
        super(ModMenuTypes.CLAY_SOLDIER_MENU.get(), pContainerId, inv);
        this.soldier = claySoldier;
        this.inventoryYOffset = 28;
        this.initPlayerInventory(inv);
        if (claySoldier != null) {
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.MAINHAND, claySoldier, 26, 90));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.OFFHAND, claySoldier, 59, 90));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.HEAD, claySoldier, 8, 18));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.CHEST, claySoldier, 8, 36));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.LEGS, claySoldier, 8, 54));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.FEET, claySoldier, 8, 72));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.CAPE, claySoldier, 77, 36));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.BACKPACK, claySoldier, 77, 54));
            this.addSlot(new ClaySoldierSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE, claySoldier, 77, 72));
        }
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }

    @Override
    protected Optional<AbstractClaySoldierEntity> getSource() {
        return Optional.ofNullable(this.soldier);
    }
}

